/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.util.newline.proseries.dr1_0_0;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectRef;

public class TimeDateUtil {
    public static final String TIME_FORMAT = "hh:mm:ss";
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    public static final String TIME_DATE_FORMAT = "hh:mm:ss MM/dd/yyyy";
    public static final int TDL_DATE_LEN = 20;
    public static final int TDL_TIME_LEN = 10;
    public static final int TDL_SUNDAY = 1;
    public static final int TDL_MONDAY = 2;
    public static final int TDL_TUESDAY = 3;
    public static final int TDL_WEDNESDAY = 4;
    public static final int TDL_THURSDAY = 5;
    public static final int TDL_FRIDAY = 6;
    public static final int TDL_SATURDAY = 7;
    public static final int TDL_SECONDS_PER_MINUTE = 60;
    public static final int TDL_MINUTES_PER_HOUR = 60;
    public static final int TDL_HOURS_PER_DAY = 24;
    public static final int TDL_SECONDS_PER_HOUR = 3600;
    public static final int TDL_MINUTES_PER_DAY = 1440;
    public static final int TDL_SECONDS_PER_DAY = 86400;
    public static final int TDL_MONTHS_PER_YEAR = 12;
    public static final int TDL_DAYS_PER_YEAR = 365;
    public static final int ONE_SECOND = 1000;
    public static final int ONE_MINUTE = 60000;
    public static final int ONE_HOUR = 3600000;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;

    public static final long nanoTime() {
        return System.currentTimeMillis() % 1000L * 1000000L;
    }

    public static final String LongDayName(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEEE");
        return formatter.format((Object)date);
    }

    public static final String ShortDayName(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("E");
        return formatter.format((Object)date);
    }

    public static final String LongMonthName(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMMM");
        return formatter.format((Object)date);
    }

    public static final String ShortMonthName(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("MMM");
        return formatter.format((Object)date);
    }

    public static final String GetFormalDateDay(long lDay) {
        if (lDay <= 0L || lDay > 31L) {
            return "";
        }
        switch ((int)lDay) {
            case 1: {
                return String.valueOf(lDay) + "st";
            }
            case 21: {
                return String.valueOf(lDay) + "st";
            }
            case 31: {
                return String.valueOf(lDay) + "st";
            }
            case 2: {
                return String.valueOf(lDay) + "nd";
            }
            case 22: {
                return String.valueOf(lDay) + "nd";
            }
            case 3: {
                return String.valueOf(lDay) + "rd";
            }
            case 23: {
                return String.valueOf(lDay) + "rd";
            }
        }
        return String.valueOf(lDay) + "th";
    }

    public static final String GetFormalDayOffset(long lOffset) {
        if (lOffset <= 0L || lOffset > 5L) {
            return "";
        }
        switch ((int)lOffset) {
            case 1: {
                return "First";
            }
            case 2: {
                return "Second";
            }
            case 3: {
                return "Third";
            }
            case 4: {
                return "Fourth";
            }
            case 5: {
                return "Last";
            }
        }
        return "";
    }

    public static final String GetFormalDate(String sDate, boolean bUKDate) throws ParseException {
        long lMonth = 0L;
        long lDay = 0L;
        long lYear = 0L;
        if (sDate.length() == 0) {
            return "";
        }
        Date date = TimeDateUtil.DateStringToDate(sDate);
        lMonth = TimeDateUtil.DateToMonth(sDate);
        lDay = TimeDateUtil.DateToDay(sDate);
        lYear = TimeDateUtil.DateToYear(sDate);
        if (lMonth < 0L || lDay <= 0L || lYear <= 0L) {
            return "";
        }
        if (lMonth >= 12L || lDay > (long)TimeDateUtil.DaysPerMonth(lMonth, lYear)) {
            return "";
        }
        if (bUKDate) {
            return String.valueOf(TimeDateUtil.GetFormalDateDay(lDay)) + " " + TimeDateUtil.LongMonthName(date) + ", " + lYear;
        }
        return String.valueOf(TimeDateUtil.LongMonthName(date)) + " " + TimeDateUtil.GetFormalDateDay(lDay) + ", " + lYear;
    }

    public static final int DaysPerMonth(long lMonth, long lYear) {
        GregorianCalendar cal = new GregorianCalendar((int)lYear, (int)lMonth, 1);
        return ((Calendar)cal).getActualMaximum(5);
    }

    public static final String TimeSerial(long lHour, long lMin, long lSec) {
        if (lHour > 23L || lMin > 59L || lSec > 59L) {
            return "";
        }
        return TimeDateUtil.FormatTime((int)lHour, (int)lMin, (int)lSec);
    }

    public static final String DateSerial(long lMonth, long lDay, long lYear, int nYrLen, boolean bUKDate) {
        if (lMonth < 0L || lMonth >= 12L || lDay == 0L) {
            return "";
        }
        if (lDay > (long)TimeDateUtil.DaysPerMonth(lMonth, lYear)) {
            return "";
        }
        String sYear = "";
        sYear = nYrLen == 2 ? "yy" : "yyyy";
        String sDate = "";
        sDate = bUKDate ? TimeDateUtil.FormatDate((int)lMonth, (int)lDay, (int)lYear, "dd/MM/" + sYear) : TimeDateUtil.FormatDate((int)lMonth, (int)lDay, (int)lYear, "MM/dd/" + sYear);
        return sDate;
    }

    public static final String LocalizedDate(String sDate, boolean bUKDate) {
        long lMonth = 0L;
        long lDay = 0L;
        long lYear = 0L;
        if (sDate.length() == 0) {
            return "";
        }
        lMonth = TimeDateUtil.DateToMonth(sDate);
        lDay = TimeDateUtil.DateToDay(sDate);
        lYear = TimeDateUtil.DateToYear(sDate);
        if (lMonth < 0L || lDay <= 0L || lYear <= 0L) {
            return "";
        }
        if (lMonth >= 12L || lDay > (long)TimeDateUtil.DaysPerMonth(lMonth, lYear)) {
            return "";
        }
        return TimeDateUtil.DateSerial(lMonth, lDay, lYear, 4, bUKDate);
    }

    public static final String TimeAdd(String sTime, long lSec, long lMin, long lHour) {
        long lNowMin = 0L;
        long lNowHour = 0L;
        long lNowSec = 0L;
        lNowSec = TimeDateUtil.TimeToSecond(sTime) + lSec;
        lNowMin = TimeDateUtil.TimeToMinute(sTime) + lMin;
        lNowHour = TimeDateUtil.TimeToHour(sTime) + lHour;
        return TimeDateUtil.TimeSerial(lNowHour, lNowMin, lNowSec);
    }

    public static final String TimeDiff(String sTime1, String sTime2, ObjectRef rlSec, ObjectRef rlMin, ObjectRef rlHour, ObjectRef rbOneLtTwo) throws ParseException {
        Date time1 = TimeDateUtil.TimeStringToDate(sTime1);
        Date time2 = TimeDateUtil.TimeStringToDate(sTime2);
        rbOneLtTwo.valueOf(time1.before(time2));
        long diffMillis = time2.getTime() - time1.getTime();
        long diffSecs = diffMillis / 1000L;
        rlSec.valueOf(diffSecs);
        long diffMins = diffMillis / 60000L;
        rlMin.valueOf(diffSecs);
        long diffHours = diffMillis / 3600000L;
        rlHour.valueOf(diffSecs);
        return TimeDateUtil.TimeSerial(diffHours, diffMins, diffSecs);
    }

    public static final int DateDiff(String sDate1, String sDate2, ObjectRef rDay, ObjectRef rMonth, ObjectRef rYear) {
        long slNowDay1 = 0L;
        long slNowMonth1 = 0L;
        long slNowYear1 = 0L;
        long slNowDay2 = 0L;
        long slNowMonth2 = 0L;
        long slNowYear2 = 0L;
        long slDay = 0L;
        long slMonth = 0L;
        long slYear = 0L;
        boolean bSwapDates = false;
        slNowDay1 = TimeDateUtil.DateToDay(sDate1);
        slNowMonth1 = TimeDateUtil.DateToMonth(sDate1);
        slNowYear1 = TimeDateUtil.DateToYear(sDate1);
        if (slNowYear1 <= 0L || slNowMonth1 <= 0L || slNowDay1 <= 0L) {
            return -1;
        }
        slNowDay2 = TimeDateUtil.DateToDay(sDate2);
        slNowMonth2 = TimeDateUtil.DateToMonth(sDate2);
        slNowYear2 = TimeDateUtil.DateToYear(sDate2);
        if (slNowYear2 <= 0L || slNowMonth2 <= 0L || slNowDay2 <= 0L) {
            return -2;
        }
        bSwapDates = slNowYear1 < slNowYear2 ? true : (slNowYear1 > slNowYear2 ? false : (slNowMonth1 < slNowMonth2 ? true : (slNowMonth1 > slNowMonth2 ? false : slNowDay1 < slNowDay2)));
        if (bSwapDates) {
            slNowDay1 = TimeDateUtil.DateToDay(sDate2);
            slNowMonth1 = TimeDateUtil.DateToMonth(sDate2);
            slNowYear1 = TimeDateUtil.DateToYear(sDate2);
            slNowDay2 = TimeDateUtil.DateToDay(sDate1);
            slNowMonth2 = TimeDateUtil.DateToMonth(sDate1);
            slNowYear2 = TimeDateUtil.DateToYear(sDate1);
        }
        slYear = slNowYear1 - slNowYear2;
        slMonth = slNowMonth1 - slNowMonth2;
        if (slMonth < 0L) {
            --slYear;
            slMonth += 12L;
        }
        slDay = slNowDay1 - slNowDay2;
        slMonth += slYear * 12L;
        if (slDay < 0L) {
            --slMonth;
        }
        if (slMonth < 0L) {
            --slYear;
        }
        while (slNowYear2 < slNowYear1 || slNowMonth2 < slNowMonth1) {
            slDay += (long)TimeDateUtil.DaysPerMonth(slNowMonth2, slNowYear2);
            if (++slNowMonth2 <= 12L) continue;
            slNowMonth2 = 1L;
            ++slNowYear2;
        }
        rDay.valueOf(slDay);
        rMonth.valueOf(slMonth);
        rYear.valueOf(slYear);
        return 0;
    }

    public static final String DateAdd(String sDate, long lDay, long lMonth, long lYear) {
        long lNowDay = 0L;
        long lNowMonth = 0L;
        long lNowYear = 0L;
        lNowDay = TimeDateUtil.DateToDay(sDate) + lDay;
        lNowMonth = TimeDateUtil.DateToMonth(sDate) + lMonth;
        lNowYear = TimeDateUtil.DateToYear(sDate) + lYear;
        return TimeDateUtil.DateSerial(lNowMonth, lNowDay, lNowYear, 4, false);
    }

    public static final int DateCompare(String sDate1, String sDate2) throws ParseException {
        Date date2;
        Date date1 = TimeDateUtil.DateStringToDate(sDate1);
        if (date1.before(date2 = TimeDateUtil.DateStringToDate(sDate2))) {
            return -1;
        }
        if (date1.after(date2)) {
            return 1;
        }
        return 0;
    }

    public static final String AmPmTime(String sTime) throws ParseException {
        Date time = TimeDateUtil.TimeStringToDate(sTime);
        return TimeDateUtil.DateToString(time, "hh:mm:ss a");
    }

    public static final String ShortAmPmTime(String sTime) throws ParseException {
        Date time = TimeDateUtil.TimeStringToDate(sTime);
        return TimeDateUtil.DateToString(time, "hh:mm a");
    }

    public static final String LocalizedTime(String sTime, boolean bMilitary) throws ParseException {
        if (sTime.length() == 0) {
            return "";
        }
        if (bMilitary) {
            Date time = TimeDateUtil.DateStringToDate(sTime);
            return TimeDateUtil.DateToString(time, "HH:mm:ss a");
        }
        return TimeDateUtil.AmPmTime(sTime);
    }

    public static final String ShortLocalizedTime(String sTime, boolean bMilitary) throws ParseException {
        if (sTime.length() == 0) {
            return "";
        }
        if (bMilitary) {
            Date time = TimeDateUtil.DateStringToDate(sTime);
            return TimeDateUtil.DateToString(time, "HH:mm a");
        }
        return TimeDateUtil.ShortAmPmTime(sTime);
    }

    public static final String CalcFloatingDate(int nDayOfMonthOffset, int nDayOfMonthDay, int nMonth, int nYear) throws ParseException {
        String sTempDate = "";
        int nDOW = 0;
        int nPos = 0;
        sTempDate = TimeDateUtil.DateSerial(nMonth, 1L, nYear, 4, false);
        Date date = TimeDateUtil.DateStringToDate(sTempDate);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        nDOW = cal.get(7);
        nPos = nDayOfMonthDay;
        if (nPos < nDOW) {
            nPos += 7;
        }
        if ((nPos -= nDOW) > 0) {
            sTempDate = TimeDateUtil.DateAdd(sTempDate, nPos, 0L, 0L);
        }
        if (nDayOfMonthOffset > 1) {
            nDOW = nDayOfMonthOffset - 1;
            if (nDOW == 4 && (nPos += 28) > TimeDateUtil.DaysPerMonth(nMonth, nYear)) {
                --nDOW;
            }
            nPos = nDOW * 7;
            sTempDate = TimeDateUtil.DateAdd(sTempDate, nPos, 0L, 0L);
        }
        return sTempDate;
    }

    public static final Date StringToDate(String str, String pattern) throws ParseException {
        Date dt = null;
        SimpleDateFormat dfTime = new SimpleDateFormat(pattern);
        if (dfTime != null) {
            dt = dfTime.parse(str);
        }
        return dt;
    }

    public static final String DateToString(Date date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        return formatter.format((Object)date);
    }

    public static final Date DateStringToDate(String sDate) throws ParseException {
        Date date = null;
        try {
            date = TimeDateUtil.StringToDate(sDate, DATE_FORMAT);
        }
        catch (ParseException e) {
            DateFormat dfTime = DateFormat.getDateInstance(3);
            if (dfTime != null) {
                date = dfTime.parse(sDate);
            }
        }
        return date;
    }

    public static final Date TimeStringToDate(String sTime) throws ParseException {
        return TimeDateUtil.StringToDate(sTime, TIME_FORMAT);
    }

    public static final String DateToStringDate(Date date) {
        return TimeDateUtil.DateToString(date, DATE_FORMAT);
    }

    public static final String DateToStringTime(Date date) {
        return TimeDateUtil.DateToString(date, TIME_FORMAT);
    }

    public static final String FormatDate(int nMonth, int nDay, int nYear) {
        GregorianCalendar cal = new GregorianCalendar(nYear, nMonth, nDay);
        return TimeDateUtil.DateToStringDate(cal.getTime());
    }

    public static final String FormatDate(int nMonth, int nDay, int nYear, String sPattern) {
        GregorianCalendar cal = new GregorianCalendar(nYear, nMonth, nDay);
        return TimeDateUtil.DateToString(cal.getTime(), sPattern);
    }

    public static final String FormatTime(int nHour, int nMin, int nSec) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, nHour);
        cal.set(12, nMin);
        cal.set(13, nSec);
        return TimeDateUtil.DateToStringTime(cal.getTime());
    }

    public static final long TimeToSecond(String sTime) {
        long lSeconds = 0L;
        try {
            Date dt = TimeDateUtil.TimeStringToDate(sTime);
            if (dt != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(dt);
                lSeconds = calendar.get(13);
            }
        }
        catch (ParseException e) {
            TimeDateUtil.error("TimeToSecond(): ParseException thrown! " + e.getMessage());
        }
        return lSeconds;
    }

    public static final long TimeToMinute(String sTime) {
        long lMinutes = 0L;
        try {
            Date dt = TimeDateUtil.TimeStringToDate(sTime);
            if (dt != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(dt);
                lMinutes = calendar.get(12);
            }
        }
        catch (ParseException e) {
            TimeDateUtil.error("TimeToMinute(): ParseException thrown! " + e.getMessage());
        }
        return lMinutes;
    }

    public static final long TimeToHour(String sTime) {
        long lHour = 0L;
        try {
            Date dt = TimeDateUtil.TimeStringToDate(sTime);
            if (dt != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(dt);
                lHour = calendar.get(10);
            }
        }
        catch (ParseException e) {
            TimeDateUtil.error("TimeToHour(): ParseException thrown! " + e.getMessage());
        }
        return lHour;
    }

    public static final long DateToDay(String sDate) {
        long lDay = 0L;
        try {
            Date dt = TimeDateUtil.DateStringToDate(sDate);
            if (dt != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(dt);
                lDay = calendar.get(5);
            }
        }
        catch (ParseException e) {
            TimeDateUtil.error("DateToDay(): ParseException thrown! " + e.getMessage());
        }
        return lDay;
    }

    public static final long DateToMonth(String sDate) {
        long lMonth = 0L;
        try {
            Date dt = TimeDateUtil.DateStringToDate(sDate);
            if (dt != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(dt);
                lMonth = calendar.get(2);
            }
        }
        catch (ParseException e) {
            TimeDateUtil.error("DateToMonth(): ParseException thrown! " + e.getMessage());
        }
        return lMonth;
    }

    public static final long DateToYear(String sDate) {
        long lYear = 0L;
        try {
            Date dt = TimeDateUtil.DateStringToDate(sDate);
            if (dt != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(dt);
                lYear = calendar.get(1);
            }
        }
        catch (ParseException e) {
            TimeDateUtil.error("DateToYear(): ParseException thrown! " + e.getMessage());
        }
        return lYear;
    }

    public static final String CurrentDate() {
        Calendar cal = Calendar.getInstance();
        return TimeDateUtil.FormatDate(cal.get(2), cal.get(5), cal.get(1));
    }

    public static final String CurrentTime() {
        Calendar cal = Calendar.getInstance();
        return TimeDateUtil.FormatTime(cal.get(10), cal.get(12), cal.get(13));
    }

    public static final long TimeDateDiff(String sTimeDate1, String sTimeDate2, int nTimeField, ObjectRef rbOneLtTwo) throws ParseException {
        long diffValue = 0L;
        Date timedate1 = null;
        Date timedate2 = null;
        try {
            timedate1 = TimeDateUtil.DateStringToDate(sTimeDate1);
            timedate2 = TimeDateUtil.DateStringToDate(sTimeDate2);
        }
        catch (ParseException e) {
            timedate1 = TimeDateUtil.TimeStringToDate(sTimeDate1);
            timedate2 = TimeDateUtil.TimeStringToDate(sTimeDate2);
        }
        switch (nTimeField) {
            case 5: {
                rbOneLtTwo.valueOf(timedate1.before(timedate2));
                long diffMillis = timedate2.getTime() - timedate1.getTime();
                diffValue = Math.abs(diffMillis / 86400000L);
                break;
            }
            case 2: {
                long lNowMonth1 = TimeDateUtil.DateToMonth(sTimeDate1);
                long lNowYear1 = TimeDateUtil.DateToYear(sTimeDate1);
                long lNowMonth2 = TimeDateUtil.DateToMonth(sTimeDate2);
                long lNowYear2 = TimeDateUtil.DateToYear(sTimeDate2);
                rbOneLtTwo.valueOf(timedate1.before(timedate2));
                long diffYears = lNowYear2 - lNowYear1;
                diffValue = lNowMonth2 - lNowMonth1;
                diffValue += Math.abs(diffYears * 12L);
                break;
            }
            case 1: {
                long lNowYear1 = TimeDateUtil.DateToYear(sTimeDate1);
                long lNowYear2 = TimeDateUtil.DateToYear(sTimeDate2);
                rbOneLtTwo.valueOf(timedate1.before(timedate2));
                diffValue = Math.abs(lNowYear2 - lNowYear1);
                break;
            }
            case 13: {
                rbOneLtTwo.valueOf(timedate1.before(timedate2));
                long diffMillis = timedate2.getTime() - timedate1.getTime();
                diffValue = Math.abs(diffMillis / 1000L);
                break;
            }
            case 12: {
                rbOneLtTwo.valueOf(timedate1.before(timedate2));
                long diffMillis = timedate2.getTime() - timedate1.getTime();
                diffValue = Math.abs(diffMillis / 60000L);
                break;
            }
            case 10: {
                rbOneLtTwo.valueOf(timedate1.before(timedate2));
                long diffMillis = timedate2.getTime() - timedate1.getTime();
                diffValue = Math.abs(diffMillis / 3600000L);
            }
        }
        return diffValue;
    }

    public static final long getNextTimeout(long timeout) {
        long nextTimeout = 0L;
        GregorianCalendar now = new GregorianCalendar();
        Date nowTime = now.getTime();
        nextTimeout = nowTime.getTime() + timeout;
        return nextTimeout;
    }

    public static final boolean isTimeExpired(long timeout) {
        Date dt;
        boolean bExpired = false;
        GregorianCalendar now = new GregorianCalendar();
        Date nowTime = now.getTime();
        if (nowTime.after(dt = new Date(timeout))) {
            bExpired = true;
        }
        return bExpired;
    }

    private static final void error(String str) {
        System.out.println("TimeDateUtil: ERROR - " + str);
    }
}

