/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.util.newline.proseries.dr1_0_0;

import com.amx.duet.core.registry.Registry;

public class Reg {
    private Registry registry = new Registry();
    private String sAppKey = "";
    private String sCurrentKey = "";
    private int nDebug = 1;
    private Object sync = new Object();

    public Reg() {
    }

    public Reg(String appkey) {
        this.setAppKey(appkey);
    }

    public void setAppKey(String key) {
        block4: {
            try {
                key = key.replace('\\', '/');
                if (key.endsWith("/")) {
                    key = key.substring(0, key.length() - 1);
                }
                this.registry.createKey(key, false);
                this.sAppKey = key;
                this.sCurrentKey = key;
            }
            catch (Exception e) {
                if (this.getDebugState() == 4) {
                    this.debug("Exception in setAppKey() " + e.getMessage());
                }
                if (this.getDebugState() != 4) break block4;
                e.printStackTrace();
            }
        }
    }

    public String getAppKey() {
        return this.sAppKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int setCurrentKey(String key) {
        block9: {
            try {
                key = key.replace('\\', '/');
                if (key.endsWith("/")) {
                    key = key.substring(0, key.length() - 1);
                }
                if (key.startsWith(this.sCurrentKey)) {
                    this.sCurrentKey = key;
                    return this.registry.createKey(this.sCurrentKey, false);
                }
                if (!this.sCurrentKey.startsWith(key)) break block9;
                if (!key.startsWith(this.sAppKey)) return -5;
                this.sCurrentKey = key;
                return this.registry.createKey(this.sCurrentKey, false);
            }
            catch (Exception e) {
                if (this.getDebugState() == 4) {
                    this.debug("Exception in setCurrentKey() " + e.getMessage());
                }
                if (this.getDebugState() != 4) return -5;
                e.printStackTrace();
                return -5;
            }
        }
        if (key.startsWith(this.sAppKey)) {
            this.sCurrentKey = key;
            return this.registry.createKey(this.sCurrentKey, false);
        } else {
            if (!key.startsWith("/")) {
                key = "/" + key;
            }
            this.sCurrentKey = String.valueOf(this.sAppKey) + key;
        }
        return this.registry.createKey(this.sCurrentKey, false);
    }

    public String getCurrentKey() {
        return this.sCurrentKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeKey(String regKey, String value) {
        boolean bSuccess;
        block6: {
            this.debug("writeRegKey(" + regKey + "," + value + ")");
            bSuccess = false;
            try {
                if (this.registry == null || this.registry.setCurrentKey(this.sCurrentKey, false) != 0) break block6;
                Object object = this.sync;
                synchronized (object) {
                    if (this.registry.setValue(regKey, value) == 0) {
                        bSuccess = true;
                    }
                }
            }
            catch (Exception e) {
                if (this.getDebugState() != 4) break block6;
                this.debug("Exception in writeRegKey() " + e.getMessage());
            }
        }
        return bSuccess;
    }

    public String readKey(String regKey) {
        String value;
        block3: {
            this.debug("readRegKey(" + regKey + ")");
            value = "";
            try {
                if (this.registry != null && this.registry.setCurrentKey(this.sCurrentKey, false) == 0) {
                    value = new String(this.registry.getValue(regKey));
                }
            }
            catch (Exception e) {
                if (this.getDebugState() != 4) break block3;
                this.debug("Exception in readRegKey() " + e.getMessage());
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(String regKey) {
        boolean bSuccess;
        block6: {
            this.debug("removeRegKey(" + regKey + ")");
            bSuccess = false;
            try {
                if (this.registry == null || this.registry.setCurrentKey(this.sCurrentKey, false) != 0) break block6;
                Object object = this.sync;
                synchronized (object) {
                    if (this.registry.deleteKey(regKey, true) == 0) {
                        bSuccess = true;
                    }
                }
            }
            catch (Exception e) {
                if (this.getDebugState() != 4) break block6;
                this.debug("Exception in removeRegKey() " + e.getMessage());
            }
        }
        return bSuccess;
    }

    public void setDebug(boolean bState) {
        this.nDebug = bState ? 4 : 1;
    }

    public void setDebugState(int nState) {
        this.nDebug = nState;
    }

    public int getDebugState() {
        return this.nDebug;
    }

    private void debug(String str) {
        if (this.nDebug > 2) {
            System.out.println("Reg: " + str);
        }
    }
}

