/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.util.newline.proseries.dr1_0_0;

import com.amx.duet.core.master.netlinx.Level;
import com.amx.duet.da.NetLinxDevice;
import java.util.Random;
import net.controlconcepts.duet.tools.util.newline.proseries.dr1_0_0.Pulser;
import net.controlconcepts.duet.tools.util.newline.proseries.dr1_0_0.WaitTimer;

public class NetLinxUtil {
    public static final int FIRST_VIRTUAL_DEVICE = 32768;
    public static final int FIRST_LOCAL_PORT = 2;
    public static final int TIMELINE_ONCE = 0;
    public static final int TIMELINE_REPEAT = 1;
    private static Pulser pulser = new Pulser(5);

    public static final int SendLevel(NetLinxDevice nlDev, int nLevel, int nValue) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("SEND_LEVEL " + nlDev.getDPS().toString() + " level = " + nLevel + " value = " + nValue);
        Level val = null;
        try {
            val = new Level((long)nValue);
        }
        catch (Exception e) {
            NetLinxUtil.error("Exception thrown! " + e.getMessage());
        }
        nlDev.sendLevel(nLevel, val);
        return 1;
    }

    public static final int SendLevel(NetLinxDevice nlDev, int nLevel, float fValue) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("SEND_LEVEL " + nlDev.getDPS().toString() + " level = " + nLevel + " value = " + fValue);
        Level val = null;
        try {
            val = new Level((double)fValue);
        }
        catch (Exception e) {
            NetLinxUtil.error("Exception thrown! " + e.getMessage());
        }
        nlDev.sendLevel(nLevel, val);
        return 1;
    }

    public static final int SendString(NetLinxDevice nlDev, String str) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("SEND_STRING " + nlDev.getDPS().toString() + " string = " + str);
        nlDev.sendString(str);
        return 1;
    }

    public static final int SendCommand(NetLinxDevice nlDev, String str) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("SEND_COMMAND " + nlDev.getDPS().toString() + " command = " + str);
        nlDev.sendCommand(str);
        return 1;
    }

    public static final int Push(NetLinxDevice nlDev, int nChan) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("PUSH " + nlDev.getDPS().toString() + " channel = " + nChan);
        nlDev.onInputChannel(nChan);
        return 1;
    }

    public static final int Release(NetLinxDevice nlDev, int nChan) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("RELEASE " + nlDev.getDPS().toString() + " channel = " + nChan);
        nlDev.offInputChannel(nChan);
        return 1;
    }

    public static final int On(NetLinxDevice nlDev, int nChan) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("CHANNEL_ON " + nlDev.getDPS().toString() + " channel = " + nChan);
        nlDev.on(nChan);
        return 1;
    }

    public static final int Off(NetLinxDevice nlDev, int nChan) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("CHANNEL_OFF " + nlDev.getDPS().toString() + " channel = " + nChan);
        nlDev.off(nChan);
        return 1;
    }

    public static final int Pulse(NetLinxDevice nlDev, int nChan) {
        if (nlDev == null) {
            return 0;
        }
        NetLinxUtil.diag("PULSE " + nlDev.getDPS().toString() + " channel = " + nChan);
        pulser.pulse(nlDev, nChan);
        return 1;
    }

    public static final void setPulseTime(int nTime) {
        pulser.setPulseTime(nTime);
    }

    public static final int getPulseTime() {
        return pulser.getPulseTime();
    }

    public static final void CancelWait(WaitTimer timer) {
        if (timer != null && timer.isStarted()) {
            timer.cancel();
        }
    }

    public static final boolean Wait(WaitTimer timer, int nTimeOut) {
        boolean bStarted = false;
        if (timer != null) {
            timer.setTimeout(nTimeOut);
            bStarted = timer.start();
        }
        return bStarted;
    }

    public static final boolean Wait(WaitTimer timer) {
        boolean bStarted = false;
        if (timer != null) {
            bStarted = timer.start();
        }
        return bStarted;
    }

    public static final int RandomNumber(int number) {
        Random rand = new Random();
        int n = rand.nextInt(number);
        return n;
    }

    public static final long MinValue(long lvar1, long lvar2) {
        return Math.min(lvar1, lvar2);
    }

    public static final long MaxValue(long lvar1, long lvar2) {
        return Math.max(lvar1, lvar2);
    }

    private static void diag(String str) {
        System.out.println("NetLinxUtil: " + str);
    }

    private static void error(String str) {
        NetLinxUtil.diag("ERROR - " + str);
    }
}

