/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.util.newline.proseries.dr1_0_0;

import com.amx.duet.core.master.netlinx.DPS;
import com.amx.duet.core.master.netlinx.Event;
import com.amx.duet.core.master.netlinx.IButtonListener;
import com.amx.duet.core.master.netlinx.IChannelListener;
import com.amx.duet.core.master.netlinx.ICustomListener;
import com.amx.duet.core.master.netlinx.IDataListener;
import com.amx.duet.core.master.netlinx.ILevelListener;
import com.amx.duet.core.master.netlinx.Level;
import com.amx.duet.da.NetLinxDevice;
import java.util.Enumeration;
import java.util.Vector;
import net.controlconcepts.duet.tools.util.newline.proseries.dr1_0_0.EventPacker;

public class LoopBackDevice
extends NetLinxDevice {
    private Vector m_channelListeners = new Vector(1);
    private Vector m_buttonListeners = new Vector(1);
    private Vector m_levelListeners = new Vector(1);
    private Vector m_dataListeners = new Vector(1);
    private Vector m_customListeners = new Vector(1);

    public LoopBackDevice(DPS dps, boolean virtualDevice) {
        super(dps, virtualDevice);
    }

    public LoopBackDevice() {
    }

    public void addButtonListener(IButtonListener buttonListener) {
        super.addButtonListener(buttonListener);
        this.m_buttonListeners.add(buttonListener);
    }

    public void addChannelListener(IChannelListener channelListener) {
        super.addChannelListener(channelListener);
        this.m_channelListeners.add(channelListener);
    }

    public void addCustomListener(ICustomListener customListener) {
        super.addCustomListener(customListener);
        this.m_customListeners.add(customListener);
    }

    public void addDataListener(IDataListener dataListener) {
        super.addDataListener(dataListener);
        this.m_dataListeners.add(dataListener);
    }

    public void addLevelListener(ILevelListener levelListener) {
        super.addLevelListener(levelListener);
        this.m_levelListeners.add(levelListener);
    }

    private void loopbackChannelEvent(Event eObj) {
        Enumeration e = this.m_channelListeners.elements();
        while (e.hasMoreElements()) {
            ((IChannelListener)e.nextElement()).handleChannelEvent(eObj);
        }
    }

    private void loopbackCustomEvent(Event eObj) {
        Enumeration e = this.m_customListeners.elements();
        while (e.hasMoreElements()) {
            ((ICustomListener)e.nextElement()).handleCustomEvent(eObj);
        }
    }

    private void loopbackDataEvent(Event eObj) {
        Enumeration e = this.m_dataListeners.elements();
        while (e.hasMoreElements()) {
            ((IDataListener)e.nextElement()).handleDataEvent(eObj);
        }
    }

    private void loopbackLevelEvent(Event eObj) {
        super.handleLevelEvent(eObj);
        Enumeration e = this.m_levelListeners.elements();
        while (e.hasMoreElements()) {
            ((ILevelListener)e.nextElement()).handleLevelEvent(eObj);
        }
    }

    public void notifyOffline() {
        super.notifyOffline();
        this.loopbackDataEvent(EventPacker.packOffline(this.getDPS()));
    }

    public void notifyOnline() {
        super.notifyOnline();
        this.loopbackDataEvent(EventPacker.packOnline(this.getDPS()));
    }

    public void off(int channelId) {
        super.off(channelId);
        this.loopbackChannelEvent(EventPacker.packOff(this.getDPS(), channelId));
    }

    public void offInputChannel(int channelId) {
        super.offInputChannel(channelId);
        this.loopbackChannelEvent(EventPacker.packOffInputChannel(this.getDPS(), channelId));
    }

    public void on(int channelId) {
        super.on(channelId);
        this.loopbackChannelEvent(EventPacker.packOn(this.getDPS(), channelId));
    }

    public void onInputChannel(int channelId) {
        super.onInputChannel(channelId);
        this.loopbackChannelEvent(EventPacker.packOnInputChannel(this.getDPS(), channelId));
    }

    public void sendCommand(byte[] str) {
        super.sendCommand(str);
        this.loopbackDataEvent(EventPacker.packSendCommand(this.getDPS(), str));
    }

    public void sendCommand(char[] str) {
        super.sendCommand(str);
        this.loopbackDataEvent(EventPacker.packSendCommand(this.getDPS(), str));
    }

    public void sendCommand(String str) {
        super.sendCommand(str);
        this.loopbackDataEvent(EventPacker.packSendCommand(this.getDPS(), str));
    }

    public void sendCommandWide(String str) {
        super.sendCommandWide(str);
        this.loopbackDataEvent(EventPacker.packSendCommandWide(this.getDPS(), str));
    }

    public void sendCustom(int id, int eventType, int flag, int value1, int value2, int value3, byte[] eventData, byte[] encode) {
        super.sendCustom(id, eventType, flag, value1, value2, value3, eventData, encode);
        this.loopbackCustomEvent(EventPacker.packSendCustom(this.getDPS(), id, eventType, flag, value1, value2, value3, eventData, encode));
    }

    public void sendCustom(int id, int eventType, int flag, int value1, int value2, int value3, char[] eventData, byte[] encode) {
        super.sendCustom(id, eventType, flag, value1, value2, value3, eventData, encode);
        this.loopbackCustomEvent(EventPacker.packSendCustom(this.getDPS(), id, eventType, flag, value1, value2, value3, eventData, encode));
    }

    public void sendCustom(int id, int eventType, int flag, int value1, int value2, int value3, String eventData, byte[] encode) {
        super.sendCustom(id, eventType, flag, value1, value2, value3, eventData, encode);
        this.loopbackCustomEvent(EventPacker.packSendCustom(this.getDPS(), id, eventType, flag, value1, value2, value3, eventData, encode));
    }

    public void sendCustomWide(int id, int eventType, int flag, int value1, int value2, int value3, String eventData, byte[] encode) {
        super.sendCustomWide(id, eventType, flag, value1, value2, value3, eventData, encode);
        this.loopbackCustomEvent(EventPacker.packSendCustomWide(this.getDPS(), id, eventType, flag, value1, value2, value3, eventData, encode));
    }

    public void sendLevel(int levelId, Level l) {
        super.sendLevel(levelId, l);
        this.loopbackLevelEvent(EventPacker.packSendLevel(this.getDPS(), levelId, l));
    }

    public void sendString(byte[] str) {
        super.sendString(str);
        this.loopbackDataEvent(EventPacker.packSendString(this.getDPS(), str));
    }

    public void sendString(char[] str) {
        super.sendString(str);
        this.loopbackDataEvent(EventPacker.packSendString(this.getDPS(), str));
    }

    public void sendString(String str) {
        super.sendString(str);
        this.loopbackDataEvent(EventPacker.packSendString(this.getDPS(), str));
    }

    public void sendStringWide(String str) {
        super.sendStringWide(str);
        this.loopbackDataEvent(EventPacker.packSendStringWide(this.getDPS(), str));
    }
}

