/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0;

import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectRef;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ValidateUtil;

public class NumericUtil {
    public static final boolean isNumeric(char cValue) {
        return cValue >= '0' && cValue <= '9';
    }

    public static final boolean isNumeric(String sValue) {
        if (sValue != null && sValue.length() > 0) {
            int i = 0;
            while (i < sValue.length()) {
                if (!NumericUtil.isNumeric(sValue.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static int ATOI(String str) {
        return ValidateUtil.ATOI(str);
    }

    public static float ATOF(String str) {
        StringBuffer sbString = new StringBuffer("");
        boolean minusFailsNow = false;
        boolean decimalFailsNow = false;
        int i = 0;
        while (i < str.length()) {
            char cChar = str.charAt(i);
            if (cChar == '-' || cChar >= '0' && cChar <= '9' || cChar == '.') {
                if (cChar == '-' && minusFailsNow) break;
                minusFailsNow = true;
                if (cChar == '.') {
                    if (decimalFailsNow) break;
                    decimalFailsNow = true;
                }
                sbString.append(str.charAt(i));
            } else if (sbString.length() > 0) break;
            ++i;
        }
        if (sbString.length() == 0) {
            NumericUtil.error("'fnStrToFloat():Number formatException, String was of zero length.");
            return Float.MIN_VALUE;
        }
        try {
            return Float.parseFloat(sbString.toString());
        }
        catch (NumberFormatException e) {
            NumericUtil.error("'fnStrToFloat():Number formatException, String was " + sbString);
            return Float.MIN_VALUE;
        }
    }

    public static final int atoi(String value) {
        int i = 0;
        try {
            ObjectRef val = new ObjectRef(value);
            i = val.toInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static final long atol(String value) {
        long l = 0L;
        try {
            ObjectRef val = new ObjectRef(value);
            l = val.toLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public static final float atof(String value) {
        float f = 0.0f;
        try {
            ObjectRef val = new ObjectRef(value);
            f = val.toFloat();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static final double atod(String value) {
        double d = 0.0;
        try {
            ObjectRef val = new ObjectRef(value);
            d = val.toDouble();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static final boolean atob(String value) {
        boolean b = false;
        try {
            ObjectRef val = new ObjectRef(value);
            b = val.toBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public static final String itoa(int value) {
        String str = "";
        try {
            ObjectRef val = new ObjectRef(value);
            str = val.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static final String ltoa(long value) {
        String str = "";
        try {
            ObjectRef val = new ObjectRef(value);
            str = val.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static final String ftoa(float value) {
        String str = "";
        try {
            ObjectRef val = new ObjectRef(value);
            str = val.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static final String dtoa(double value) {
        String str = "";
        try {
            ObjectRef val = new ObjectRef(value);
            str = val.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static final String btoa(boolean value) {
        String str = "";
        try {
            ObjectRef val = new ObjectRef(value);
            str = val.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    private static void error(String str) {
        System.out.println("NumericUtil: ERROR - " + str);
    }
}

