/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0;

public class HexUtil {
    public static final int hextoi(String hex) {
        char[] HexMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String szStr = hex.toUpperCase();
        int MAX_CHARS = HexMap.length;
        int nResult = Integer.MIN_VALUE;
        if (szStr == null || szStr.length() < 2) {
            return Integer.MIN_VALUE;
        }
        boolean bFound = false;
        int i = 0;
        while (i < szStr.length()) {
            bFound = false;
            int j = 0;
            while (j < MAX_CHARS) {
                if (szStr.charAt(i) == HexMap[j]) {
                    nResult <<= 4;
                    nResult |= j;
                    bFound = true;
                    break;
                }
                ++j;
            }
            if (!bFound) break;
            ++i;
        }
        return nResult;
    }

    public static final String itohex(int value) {
        String str = "";
        try {
            str = Integer.toHexString(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return str;
    }

    public static int HEXTOI(byte cZa, byte cZb) {
        if (cZa < 48 || cZa > 70 || cZa > 57 && cZa < 65) {
            HexUtil.error("First parameter was invalid (number range should be 048-057, 065-070. You entered: " + cZa);
            return Integer.MIN_VALUE;
        }
        if (cZb < 48 || cZb > 70 || cZb > 57 && cZb < 65) {
            HexUtil.error("Second parameter was invalid (number range should be 048-057, 065-070. You entered: " + cZb);
            return Integer.MIN_VALUE;
        }
        int a = cZa < 64 ? cZa - 48 : cZa - 65 + 10;
        int b = cZb < 64 ? cZb - 48 : cZb - 65 + 10;
        return (a << 4) + b;
    }

    public static int HEXTOI(char cZa, char cZb) {
        cZa = Character.toUpperCase(cZa);
        cZb = Character.toUpperCase(cZb);
        if ((byte)cZa < 48 || (byte)cZa > 70 || (byte)cZa > 57 && (byte)cZa < 65) {
            HexUtil.error("First parameter was invalid (number range should be '1'-'9', 'A'-'F'. You entered: " + cZa);
            return Integer.MIN_VALUE;
        }
        if ((byte)cZb < 48 || (byte)cZb > 70 || (byte)cZb > 57 && (byte)cZb < 65) {
            HexUtil.error("First parameter was invalid (number range should be '1'-'9', 'A'-'F'. You entered: " + cZb);
            return Integer.MIN_VALUE;
        }
        int a = (byte)cZa < 64 ? (byte)cZa - 48 : (byte)cZa - 65 + 10;
        int b = (byte)cZb < 64 ? (byte)cZb - 48 : (byte)cZb - 65 + 10;
        return (a << 4) + b;
    }

    public static char HEXTOA(byte cZa, byte cZb) {
        if (cZa < 48 || cZa > 70 || cZa > 57 && cZa < 65) {
            HexUtil.error("First parameter was invalid (number range should be 048-057, 065-070. You entered: " + cZa);
            return '\u0000';
        }
        if (cZb < 48 || cZb > 70 || cZb > 57 && cZb < 65) {
            HexUtil.error("Second parameter was invalid (number range should be 048-057, 065-070. You entered: " + cZb);
            return '\u0000';
        }
        int a = cZa < 64 ? cZa - 48 : cZa - 55;
        int b = cZb < 64 ? cZb - 48 : cZb - 55;
        return (char)((a << 4) + b);
    }

    private static void error(String str) {
        System.out.println("HexUtil: ERROR - " + str);
    }
}

