/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.net.tcp.newline.proseries.dr1_0_0;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import net.controlconcepts.duet.tools.net.tcp.newline.proseries.dr1_0_0.SocketConnectionListener;

public class SocketConnection
extends Thread {
    public static final int CONNECTED = 1;
    public static final int TIMEOUT = -1;
    public static final int CLOSED = -2;
    public static final int INVALID_HOST = -3;
    public static final int FAILED_CONNECT = -4;
    public static final int INFINITE = 0;
    private Socket m_socket = null;
    private boolean m_connected = false;
    private InetAddress m_addr = null;
    private String m_addrStr = null;
    private int m_port = 0;
    private SocketConnectionListener m_listener = null;
    private int m_timeout = 0;
    private int m_bufferSize = 10000;
    private byte[] m_readBuff;
    private BufferedInputStream m_inStream;
    private BufferedOutputStream m_outStream;
    private boolean m_isRunning = false;
    private boolean m_doConnect = false;
    private Object connectLock = new Object();
    private boolean m_continueRunning = true;
    private Object writeSync = new Object();
    private boolean m_okToSend = true;
    private LinkedList m_queue;
    private int nDebug = 1;

    public void initConnection(String addrStr, int port, int bufferSize, SocketConnectionListener listener, int timeout) {
        this.debug("initConnection(" + addrStr + ", " + port + ", " + timeout + ")");
        if (listener == null) {
            this.error("Invalid Listener");
            return;
        }
        if (addrStr == null) {
            this.error("Invalid Host address");
            return;
        }
        this.m_queue = new LinkedList();
        this.m_addr = null;
        this.m_addrStr = addrStr;
        this.m_port = port;
        this.m_listener = listener;
        this.m_timeout = timeout;
        this.m_bufferSize = bufferSize;
        this.start();
    }

    private SocketConnection() {
    }

    public SocketConnection(InetAddress addr, int port, int bufferSize, SocketConnectionListener listener) {
        this.debug("SocketConnection(" + addr + ", " + port + ")");
        this.initConnection(addr.getHostAddress(), port, bufferSize, listener, 0);
    }

    public SocketConnection(String host, int port, int bufferSize, SocketConnectionListener listener) {
        this.debug("SocketConnection(" + host + ", " + port + ")");
        this.initConnection(host, port, bufferSize, listener, 0);
    }

    public SocketConnection(InetAddress addr, int port, int bufferSize, SocketConnectionListener listener, int timeout) {
        this.debug("SocketConnection(" + addr + ", " + port + ", " + timeout + ")");
        this.initConnection(addr.getHostAddress(), port, bufferSize, listener, timeout);
    }

    public SocketConnection(String host, int port, int bufferSize, SocketConnectionListener listener, int timeout) {
        this.debug("SocketConnection(" + host + ", " + port + ", " + timeout + ")");
        this.initConnection(host, port, bufferSize, listener, timeout);
    }

    public boolean setAddressAndPort(String host, int port) {
        this.debug("setAddressAndPort(" + host + ", " + port + ")");
        this.m_addr = null;
        this.m_addrStr = host;
        this.m_port = port;
        return true;
    }

    public boolean setAddressAndPort(InetAddress addr, int port) {
        this.debug("setAddressAndPort(" + addr + ", " + port + ")");
        this.setAddressAndPort(addr.getHostAddress(), port);
        return true;
    }

    public void setTimeout(int timeout) {
        this.debug("setTimeout(" + timeout + ")");
        this.m_timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect() {
        this.debug("connect()");
        if (this.m_addrStr == null) {
            return false;
        }
        Object object = this.connectLock;
        synchronized (object) {
            block5: {
                if (!this.m_connected && !this.m_doConnect) break block5;
                return true;
            }
            this.m_doConnect = true;
            this.connectLock.notify();
        }
        return true;
    }

    public void disconnect() {
        block3: {
            this.debug("disconnect()");
            if (this.m_socket != null) {
                try {
                    this.m_inStream = null;
                    this.m_outStream = null;
                    this.m_socket.close();
                    this.m_socket = null;
                }
                catch (IOException e) {
                    this.error("disconnect(): close failure");
                    if (this.getDebugState() != 4) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isConnected() {
        this.debug("isConnected(" + (this.m_socket != null && this.m_connected) + ")");
        return this.m_socket != null && this.m_connected;
    }

    public void dispose() {
        this.debug("dispose()");
        this.m_continueRunning = false;
        if (this.m_connected) {
            this.disconnect();
        }
        if (this.m_isRunning) {
            this.interrupt();
            try {
                this.join(this.m_timeout + 10);
            }
            catch (InterruptedException e) {
                this.error("dispose(): failed to terminate socket thread");
            }
        }
    }

    public void finalize() {
        this.debug("finalize()");
        this.dispose();
    }

    private void createSocket() {
        block8: {
            this.debug("createSocket: creating socket");
            this.resetDoConnect();
            try {
                this.debug("createSocket(): initializing...");
                this.m_socket = new Socket(this.m_addr, this.m_port);
                if (this.m_timeout != 0) {
                    this.m_socket.setSoTimeout(this.m_timeout);
                }
                this.m_inStream = new BufferedInputStream(this.m_socket.getInputStream());
                this.m_outStream = new BufferedOutputStream(this.m_socket.getOutputStream());
                this.m_connected = true;
                this.debug("createSocket: socket created");
                if (this.m_listener != null) {
                    this.m_listener.handleSocketStatus(1);
                }
            }
            catch (Exception e) {
                block7: {
                    this.error("createSocket: IO exception");
                    try {
                        this.m_outStream = null;
                        this.m_inStream = null;
                        if (this.m_socket != null) {
                            this.m_socket.close();
                        }
                        this.m_socket = null;
                    }
                    catch (IOException ex) {
                        if (this.getDebugState() != 4) break block7;
                        ex.printStackTrace();
                    }
                }
                this.error("createSocket: socket create failed");
                if (this.m_listener == null) break block8;
                this.m_listener.handleSocketStatus(-4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean write(byte[] data) {
        this.debug("write()");
        try {
            if (this.m_outStream == null) {
                this.error("write: Invalid output stream");
                return false;
            }
            Object object = this.writeSync;
            synchronized (object) {
                this.m_outStream.write(data);
                this.m_outStream.flush();
                return true;
            }
        }
        catch (IOException e) {
            this.error("write: IOException during socket write");
            if (this.getDebugState() != 4) return false;
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeQueued(byte[] data) {
        this.debug("writeQueued()");
        LinkedList linkedList = this.m_queue;
        synchronized (linkedList) {
            if (this.m_queue.size() == 0 && this.m_okToSend && this.m_outStream != null) {
                this.diag("writeQueued(): no queue, sending msg");
                this.m_okToSend = false;
                return this.write(data);
            }
            this.diag("writeQueued(): queueing message");
            byte[] copy = new byte[data.length];
            System.arraycopy(data, 0, copy, 0, data.length);
            this.m_queue.add(copy);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushQueue(boolean send) {
        this.debug("flushQueue()");
        LinkedList linkedList = this.m_queue;
        synchronized (linkedList) {
            if (send) {
                while (this.m_queue.size() > 0) {
                    byte[] data = (byte[])this.m_queue.removeFirst();
                    this.write(data);
                }
            } else {
                this.m_queue.clear();
            }
        }
    }

    public void setOKtoSendTrue() {
        this.debug("setOKtoSendTrue()");
        this.m_okToSend = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetDoConnect() {
        this.debug("resetDoConnect()");
        Object object = this.connectLock;
        synchronized (object) {
            this.m_doConnect = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.debug("run()");
        this.m_readBuff = new byte[this.m_bufferSize];
        this.m_isRunning = true;
        while (this.m_continueRunning) {
            Object object;
            if (this.m_doConnect) {
                if (this.m_addrStr == null) {
                    this.error("no host for connection");
                    this.m_addr = null;
                    this.resetDoConnect();
                } else if (this.m_addr == null) {
                    try {
                        this.debug("run(): Getting host address...");
                        this.m_addr = InetAddress.getByName(this.m_addrStr);
                    }
                    catch (UnknownHostException e) {
                        this.error("could not resolve host: " + this.m_addrStr);
                        this.resetDoConnect();
                    }
                }
                if (this.m_addr != null) {
                    this.debug("run(): Creating socket...");
                    this.createSocket();
                }
            }
            if (this.m_connected) {
                block30: {
                    try {
                        int bytesRead = 0;
                        if (this.m_inStream != null) {
                            bytesRead = this.m_inStream.read(this.m_readBuff);
                        }
                        if (bytesRead > 0) {
                            this.debug("Bytes received[" + bytesRead + "]: " + new String(this.m_readBuff, 0, bytesRead));
                        } else {
                            this.debug("Bytes received[" + bytesRead + "]:");
                        }
                        if (bytesRead > 0 && this.m_listener != null) {
                            this.m_listener.handleReceive(bytesRead, this.m_readBuff);
                        } else if (bytesRead <= 0) {
                            this.debug("run(): Closing socket...");
                            this.m_connected = false;
                            this.disconnect();
                            this.flushQueue(false);
                            if (this.m_listener != null) {
                                this.m_listener.handleSocketStatus(-2);
                            }
                        }
                    }
                    catch (InterruptedIOException e) {
                        this.debug("run(): InterruptedIOException - " + e.toString());
                        if (this.m_listener != null) {
                            this.m_listener.handleSocketStatus(-1);
                        }
                    }
                    catch (Exception e) {
                        this.debug("run(): Exception - " + e.toString());
                        this.error("run: failed data read");
                        if (this.getDebugState() == 4) {
                            e.printStackTrace();
                        }
                        this.debug("run(): Closing socket...");
                        this.m_connected = false;
                        this.disconnect();
                        this.flushQueue(false);
                        if (this.m_listener == null) break block30;
                        this.m_listener.handleSocketStatus(-2);
                    }
                }
                object = this.m_queue;
                synchronized (object) {
                    if (this.m_queue.size() > 0 && this.m_okToSend) {
                        this.debug("run() sending queued message");
                        this.m_okToSend = false;
                        byte[] data = (byte[])this.m_queue.removeFirst();
                        this.write(data);
                    }
                    continue;
                }
            }
            object = this.connectLock;
            synchronized (object) {
                try {
                    this.connectLock.wait(5000L);
                }
                catch (InterruptedException e) {
                    this.debug("run(): InterruptedException - " + e.toString());
                }
            }
        }
        this.m_isRunning = false;
    }

    public void setDebug(boolean bState) {
        this.nDebug = bState ? 4 : 1;
    }

    public void setDebugState(int nState) {
        this.nDebug = nState;
    }

    public int getDebugState() {
        return this.nDebug;
    }

    private void diag(String str) {
        System.out.println("SocketConnection: " + str);
    }

    private void error(String str) {
        this.diag("ERROR - " + str);
    }

    private void debug(String str) {
        if (this.getDebugState() > 2) {
            this.diag(str);
        }
    }
}

