/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0;

import com.amx.duet.core.master.netlinx.DPS;
import java.net.InetAddress;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ClassName;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.Logger;

public class ValidateUtil {
    private static String className = ClassName.getClassName(ValidateUtil.class.getName());

    public static String validateBaudRate(String rate, String[] validRates, String defaultRate) {
        int n;
        if (rate != null && rate.length() > 0) {
            n = 0;
            while (n < validRates.length) {
                if (rate.equals(validRates[n])) {
                    return rate;
                }
                ++n;
            }
        }
        n = 0;
        while (n < validRates.length) {
            if (defaultRate.equals(validRates[n])) {
                ValidateUtil.error("Invalid value for the Baud Rate. Using default rate.");
                return defaultRate;
            }
            ++n;
        }
        ValidateUtil.error("Invalid value for the Baud Rate, and default rate. Using Null");
        return null;
    }

    public static String validateDeviceID(String deviceID, int nMinID, int nMaxID, String defaultID) {
        int nID;
        if (deviceID != null && deviceID.length() > 0 && (nID = ValidateUtil.ATOI(deviceID)) >= nMinID && nID <= nMaxID) {
            return deviceID;
        }
        int dID = ValidateUtil.ATOI(defaultID);
        if (dID >= nMinID && dID <= nMaxID) {
            ValidateUtil.error("Invalid value for the Device ID. Returning default ID");
            return defaultID;
        }
        ValidateUtil.error("Invalid value for the Device ID and default ID. Returning Null");
        return null;
    }

    public static String validatePollTime(String polltime, long nTime) {
        if (polltime != null && polltime.length() > 0) {
            return polltime;
        }
        ValidateUtil.error("Invalid value for the Poll Time.");
        return Integer.toString((int)(nTime / 1000L));
    }

    public static String validatePollTime(String polltime, long lMin, long lMax, long lTime) {
        if (polltime != null && polltime.length() > 0) {
            int nPoll = ValidateUtil.ATOI(polltime);
            if (nPoll == 0 || (long)nPoll >= lMin && (long)nPoll <= lMax) {
                return polltime;
            }
            ValidateUtil.error("Poll Time out of range. Returning default Poll Time.");
        } else {
            ValidateUtil.error("Invalid value for the Poll Time. Returning default Poll Time.");
        }
        return Long.toString(lTime);
    }

    public static String validateTimeoutCount(String timeout, int nMax, int nDefault) {
        if (timeout != null && timeout.length() > 0) {
            int nTime = ValidateUtil.ATOI(timeout);
            if (nTime >= 0 && nTime <= nMax) {
                return timeout;
            }
            ValidateUtil.error("Timeout Count out of range. Returning default Timeout Count.");
        } else {
            ValidateUtil.error("Invalid value for the Timeout Count. Returning default Timeout Count.");
        }
        return Integer.toString(nDefault);
    }

    public static String validateReconnnectTime(String connectTime, long lMin, long lMax, long lTime) {
        if (connectTime != null && connectTime.length() > 0) {
            int nConnect = ValidateUtil.ATOI(connectTime);
            if ((long)nConnect >= lMin && (long)nConnect <= lMax) {
                return connectTime;
            }
            ValidateUtil.error("Reconnnect Time out of range. Returning default Reconnnect Time.");
        } else {
            ValidateUtil.error("Invalid value for the Reconnnect Time. Returning default Reconnnect Time.");
        }
        return Long.toString(lTime);
    }

    public static final boolean isValidDPS(String dps) {
        boolean bValid = false;
        if (dps != null && dps.length() > 0) {
            try {
                DPS dev = new DPS(dps);
                bValid = ValidateUtil.isValidDPS(dev);
                Object var2_2 = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bValid;
    }

    public static final boolean isValidDPS(DPS dps) {
        boolean bValid = false;
        if (dps != null && dps.getDevice() > 0 && dps.getPort() > 0) {
            bValid = true;
        }
        return bValid;
    }

    public static final boolean isValidIP(String ip) {
        boolean bValid = false;
        if (ip != null && ip.length() > 0) {
            try {
                InetAddress addr = InetAddress.getByName(ip);
                if (addr != null) {
                    bValid = true;
                }
                Object var2_2 = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bValid;
    }

    private static void error(String str) {
        Logger.error(className, str);
    }

    public static int ATOI(String str) {
        StringBuffer sbString = new StringBuffer("");
        boolean minusFailsNow = false;
        int i = 0;
        while (i < str.length()) {
            char cChar = str.charAt(i);
            if (cChar == '-' || cChar >= '0' && cChar <= '9') {
                if (cChar == '-' && minusFailsNow) break;
                minusFailsNow = true;
                sbString.append(str.charAt(i));
            } else if (sbString.length() > 0) break;
            ++i;
        }
        if (sbString.length() == 0) {
            ValidateUtil.error("'ATOI():Number formatException, String was of zero length");
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(sbString.toString());
        }
        catch (NumberFormatException e) {
            ValidateUtil.error("'ATOI():Number formatException, String was " + sbString);
            return Integer.MIN_VALUE;
        }
    }
}

