/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0;

import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectType;

public class ObjectRef {
    private Object ref = null;
    private ObjectType type = ObjectType.INVALID;

    public ObjectRef(boolean b) {
        this.valueOf(b);
    }

    public ObjectRef(byte b) {
        this.valueOf(b);
    }

    public ObjectRef(char c) {
        this.valueOf(c);
    }

    public ObjectRef(short s) {
        this.valueOf(s);
    }

    public ObjectRef(int i) {
        this.valueOf(i);
    }

    public ObjectRef(long l) {
        this.valueOf(l);
    }

    public ObjectRef(float f) {
        this.valueOf(f);
    }

    public ObjectRef(double d) {
        this.valueOf(d);
    }

    public ObjectRef(String str) {
        this.valueOf(str);
    }

    public ObjectRef(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.valueOf(o);
    }

    public ObjectRef(Object o, ObjectType refType) {
        if (o == null || refType == null) {
            throw new NullPointerException();
        }
        this.valueOf(o, refType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectRef(ObjectType refType) {
        if (refType == null) throw new NullPointerException();
        this.type = refType;
        if (ObjectType.BOOL.equals(refType)) {
            this.ref = new Boolean(false);
            return;
        } else if (ObjectType.BYTE.equals(refType)) {
            this.ref = new Byte(0);
            return;
        } else if (ObjectType.CHAR.equals(refType)) {
            this.ref = new Character('\u0000');
            return;
        } else if (ObjectType.SHORT.equals(refType)) {
            this.ref = new Short(0);
            return;
        } else if (ObjectType.INTEGER.equals(refType)) {
            this.ref = new Integer(0);
            return;
        } else if (ObjectType.LONG.equals(refType)) {
            this.ref = new Long(0L);
            return;
        } else if (ObjectType.FLOAT.equals(refType)) {
            this.ref = new Float(0.0f);
            return;
        } else if (ObjectType.DOUBLE.equals(refType)) {
            this.ref = new Double(0.0);
            return;
        } else {
            if (!ObjectType.STRING.equals(refType)) throw new UnsupportedOperationException(refType + " object creation is not supported by this construction method");
            this.ref = new String("");
        }
    }

    public Object valueOf(boolean b) {
        this.ref = new Boolean(b);
        this.type = ObjectType.BOOL;
        return this.ref;
    }

    public Object valueOf(byte b) {
        this.ref = new Byte(b);
        this.type = ObjectType.BYTE;
        return this.ref;
    }

    public Object valueOf(char c) {
        this.ref = new Character(c);
        this.type = ObjectType.CHAR;
        return this.ref;
    }

    public Object valueOf(short s) {
        this.ref = new Short(s);
        this.type = ObjectType.SHORT;
        return this.ref;
    }

    public Object valueOf(int i) {
        this.ref = new Integer(i);
        this.type = ObjectType.INTEGER;
        return this.ref;
    }

    public Object valueOf(long l) {
        this.ref = new Long(l);
        this.type = ObjectType.LONG;
        return this.ref;
    }

    public Object valueOf(float f) {
        this.ref = new Float(f);
        this.type = ObjectType.FLOAT;
        return this.ref;
    }

    public Object valueOf(double d) {
        this.ref = new Double(d);
        this.type = ObjectType.DOUBLE;
        return this.ref;
    }

    public Object valueOf(String str) {
        this.ref = str;
        this.type = ObjectType.STRING;
        return this.ref;
    }

    public Object valueOf(Object o) {
        this.ref = o;
        this.type = ObjectType.OBJECT;
        return this.ref;
    }

    public Object valueOf(Object o, ObjectType refType) {
        ObjectType ot;
        block4: {
            ot = ObjectType.INVALID;
            try {
                if (refType == null) break block4;
                for (ObjectType temp : ObjectType.VALUES) {
                    if (!refType.equals(temp)) continue;
                    ot = temp;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ot.equals(ObjectType.INVALID)) {
            throw new UnsupportedOperationException(refType + " object creation for this type is not supported");
        }
        this.ref = o;
        this.type = refType;
        return this.ref;
    }

    public boolean booleanValue() {
        if (this.ref != null && this.ref instanceof Boolean) {
            return (Boolean)this.ref;
        }
        return false;
    }

    public byte byteValue() {
        if (this.ref != null && this.ref instanceof Byte) {
            return (Byte)this.ref;
        }
        return 0;
    }

    public char charValue() {
        if (this.ref != null && this.ref instanceof Character) {
            return ((Character)this.ref).charValue();
        }
        return '\u0000';
    }

    public short shortValue() {
        if (this.ref != null && this.ref instanceof Short) {
            return (Short)this.ref;
        }
        return 0;
    }

    public int intValue() {
        if (this.ref != null && this.ref instanceof Integer) {
            return (Integer)this.ref;
        }
        return 0;
    }

    public long longValue() {
        if (this.ref != null && this.ref instanceof Long) {
            return (Long)this.ref;
        }
        return 0L;
    }

    public float floatValue() {
        if (this.ref != null && this.ref instanceof Float) {
            return ((Float)this.ref).floatValue();
        }
        return 0.0f;
    }

    public double doubleValue() {
        if (this.ref != null && this.ref instanceof Double) {
            return (Double)this.ref;
        }
        return 0.0;
    }

    public String stringValue() {
        if (this.ref != null && this.ref instanceof String) {
            return (String)this.ref;
        }
        return "";
    }

    public Object getValue() {
        return this.ref;
    }

    public ObjectType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        return this.ref.equals(obj);
    }

    public String toString() {
        return this.ref.toString();
    }

    private String getNumeric(String value) {
        StringBuffer sbString = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c != '-' && (c < '0' || c > '9')) break;
            sbString.append(c);
            ++i;
        }
        return sbString.toString();
    }

    public boolean toBoolean() {
        if (this.ref != null) {
            if (this.ref instanceof String) {
                if (!((String)this.ref).equals("0") && ((String)this.ref).equals("true")) {
                    return true;
                }
                return Boolean.valueOf((String)this.ref);
            }
            if (this.ref instanceof Boolean) {
                return this.booleanValue();
            }
            if (this.ref instanceof Byte) {
                return this.byteValue() != 0;
            }
            if (this.ref instanceof Character) {
                return this.charValue() != '\u0000';
            }
            if (this.ref instanceof Short) {
                return this.shortValue() != 0;
            }
            if (this.ref instanceof Integer) {
                return this.intValue() != 0;
            }
            if (this.ref instanceof Long) {
                return this.longValue() != 0L;
            }
            if (this.ref instanceof Float) {
                return this.floatValue() != 0.0f;
            }
            if (this.ref instanceof Double) {
                return this.doubleValue() != 0.0;
            }
            throw new ClassCastException("Object reference could not be casted");
        }
        return false;
    }

    public byte toByte() {
        if (this.ref != null) {
            if (this.ref instanceof String) {
                String val = this.getNumeric((String)this.ref);
                if (val.equals("true")) {
                    return 1;
                }
                return Byte.parseByte(val);
            }
            if (this.ref instanceof Boolean) {
                return this.booleanValue() ? (byte)1 : 0;
            }
            if (this.ref instanceof Byte) {
                return this.byteValue();
            }
            if (this.ref instanceof Character) {
                return (byte)this.charValue();
            }
            if (this.ref instanceof Short) {
                return (byte)this.shortValue();
            }
            if (this.ref instanceof Integer) {
                return (byte)this.intValue();
            }
            if (this.ref instanceof Long) {
                return (byte)this.longValue();
            }
            if (this.ref instanceof Float) {
                return (byte)this.floatValue();
            }
            if (this.ref instanceof Double) {
                return (byte)this.doubleValue();
            }
            throw new ClassCastException("Object reference could not be casted");
        }
        return 0;
    }

    public char toChar() {
        if (this.ref != null) {
            if (this.ref instanceof String) {
                String val = this.getNumeric((String)this.ref);
                if (val.equals("true")) {
                    return '\u0001';
                }
                return (char)Integer.parseInt(val);
            }
            if (this.ref instanceof Boolean) {
                return this.booleanValue() ? (char)'\u0001' : '\u0000';
            }
            if (this.ref instanceof Byte) {
                return (char)this.byteValue();
            }
            if (this.ref instanceof Character) {
                return this.charValue();
            }
            if (this.ref instanceof Short) {
                return (char)this.shortValue();
            }
            if (this.ref instanceof Integer) {
                return (char)this.intValue();
            }
            if (this.ref instanceof Long) {
                return (char)this.longValue();
            }
            if (this.ref instanceof Float) {
                return (char)this.floatValue();
            }
            if (this.ref instanceof Double) {
                return (char)this.doubleValue();
            }
            throw new ClassCastException("Object reference could not be casted");
        }
        return '\u0000';
    }

    public short toShort() {
        if (this.ref != null) {
            if (this.ref instanceof String) {
                String val = this.getNumeric((String)this.ref);
                if (val.equals("true")) {
                    return 1;
                }
                return Short.parseShort(val);
            }
            if (this.ref instanceof Boolean) {
                return this.booleanValue() ? (short)1 : 0;
            }
            if (this.ref instanceof Byte) {
                return this.byteValue();
            }
            if (this.ref instanceof Character) {
                return (short)this.charValue();
            }
            if (this.ref instanceof Short) {
                return this.shortValue();
            }
            if (this.ref instanceof Integer) {
                return (short)this.intValue();
            }
            if (this.ref instanceof Long) {
                return (short)this.longValue();
            }
            if (this.ref instanceof Float) {
                return (short)this.floatValue();
            }
            if (this.ref instanceof Double) {
                return (short)this.doubleValue();
            }
            throw new ClassCastException("Object reference could not be casted");
        }
        return 0;
    }

    public int toInt() {
        if (this.ref != null) {
            if (this.ref instanceof String) {
                String val = this.getNumeric((String)this.ref);
                if (val.equals("true")) {
                    return 1;
                }
                return Integer.parseInt(val);
            }
            if (this.ref instanceof Boolean) {
                return this.booleanValue() ? 1 : 0;
            }
            if (this.ref instanceof Byte) {
                return this.byteValue();
            }
            if (this.ref instanceof Character) {
                return this.charValue();
            }
            if (this.ref instanceof Short) {
                return this.shortValue();
            }
            if (this.ref instanceof Integer) {
                return this.intValue();
            }
            if (this.ref instanceof Long) {
                return (int)this.longValue();
            }
            if (this.ref instanceof Float) {
                return (int)this.floatValue();
            }
            if (this.ref instanceof Double) {
                return (int)this.doubleValue();
            }
            throw new ClassCastException("Object reference could not be casted");
        }
        return 0;
    }

    public long toLong() {
        if (this.ref != null) {
            if (this.ref instanceof String) {
                String val = this.getNumeric((String)this.ref);
                if (val.equals("true")) {
                    return 1L;
                }
                return Long.parseLong(val);
            }
            if (this.ref instanceof Boolean) {
                return this.booleanValue() ? 1L : 0L;
            }
            if (this.ref instanceof Byte) {
                return this.byteValue();
            }
            if (this.ref instanceof Character) {
                return this.charValue();
            }
            if (this.ref instanceof Short) {
                return this.shortValue();
            }
            if (this.ref instanceof Integer) {
                return this.intValue();
            }
            if (this.ref instanceof Long) {
                return this.longValue();
            }
            if (this.ref instanceof Float) {
                return (long)this.floatValue();
            }
            if (this.ref instanceof Double) {
                return (long)this.doubleValue();
            }
            throw new ClassCastException("Object reference could not be casted");
        }
        return 0L;
    }

    public float toFloat() {
        if (this.ref != null) {
            if (this.ref instanceof String) {
                String val = (String)this.ref;
                if (val.equals("true")) {
                    return 1.0f;
                }
                return Float.parseFloat(val);
            }
            if (this.ref instanceof Boolean) {
                return this.booleanValue() ? 1.0f : 0.0f;
            }
            if (this.ref instanceof Byte) {
                return this.byteValue();
            }
            if (this.ref instanceof Character) {
                return this.charValue();
            }
            if (this.ref instanceof Short) {
                return this.shortValue();
            }
            if (this.ref instanceof Integer) {
                return this.intValue();
            }
            if (this.ref instanceof Long) {
                return this.longValue();
            }
            if (this.ref instanceof Float) {
                return this.floatValue();
            }
            if (this.ref instanceof Double) {
                return (float)this.doubleValue();
            }
            throw new ClassCastException("Object reference could not be casted");
        }
        return 0.0f;
    }

    public double toDouble() {
        if (this.ref != null) {
            if (this.ref instanceof String) {
                String val = (String)this.ref;
                if (val.equals("true")) {
                    return 1.0;
                }
                return Double.parseDouble(val);
            }
            if (this.ref instanceof Boolean) {
                return this.booleanValue() ? 1.0 : 0.0;
            }
            if (this.ref instanceof Byte) {
                return this.byteValue();
            }
            if (this.ref instanceof Character) {
                return this.charValue();
            }
            if (this.ref instanceof Short) {
                return this.shortValue();
            }
            if (this.ref instanceof Integer) {
                return this.intValue();
            }
            if (this.ref instanceof Long) {
                return this.longValue();
            }
            if (this.ref instanceof Float) {
                return this.floatValue();
            }
            if (this.ref instanceof Double) {
                return this.doubleValue();
            }
            throw new ClassCastException("Object reference could not be casted");
        }
        return 0.0;
    }
}

