/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.Logger;

public class ByteBuffer {
    private ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private String digits = "0123456789ABCDEF";

    public ByteBuffer() {
    }

    public ByteBuffer(int b) {
        this.append(b);
    }

    public ByteBuffer(byte[] original) {
        this.append(original);
    }

    public ByteBuffer(byte[] value, int offset, int size) {
        this.append(value, offset, size);
    }

    public ByteBuffer(String value) {
        this.append(value);
    }

    public ByteBuffer(char[] value) {
        this.append(value);
    }

    public void append(int b) {
        this.stream.write(b);
    }

    public void append(byte[] value) {
        try {
            this.stream.write(value);
        }
        catch (IOException e) {
            this.error("IOException thrown: " + e.getMessage());
        }
    }

    public void append(byte[] value, int offset, int size) {
        this.stream.write(value, offset, size);
    }

    public void append(String value) {
        this.append(value.getBytes());
    }

    public void append(char[] value) {
        String str = new String(value);
        this.append(str.getBytes());
    }

    public byte[] toByteArray() {
        return this.stream.toByteArray();
    }

    public char[] toCharArray() {
        String str = this.stream.toString();
        return str.toCharArray();
    }

    public byte byteAt(int index) {
        byte[] barray = this.stream.toByteArray();
        if (index < barray.length) {
            return barray[index];
        }
        throw new IndexOutOfBoundsException();
    }

    public int UByteAt(int index) {
        byte[] barray = this.stream.toByteArray();
        if (index < barray.length) {
            return barray[index] & 0xFF;
        }
        throw new IndexOutOfBoundsException();
    }

    public char charAt(int index) {
        String str = this.stream.toString();
        if (index < str.length()) {
            return str.charAt(index);
        }
        throw new IndexOutOfBoundsException();
    }

    public String toString() {
        return this.stream.toString();
    }

    public String toHex() {
        byte[] bArr = this.stream.toByteArray();
        byte[] tempArr = new byte[bArr.length * 2];
        int i = 0;
        while (i < bArr.length) {
            int dig1 = bArr[i] >> 4 & 0xF;
            int dig2 = bArr[i] & 0xF;
            tempArr[i * 2] = (byte)this.digits.charAt(dig1);
            tempArr[i * 2 + 1] = (byte)this.digits.charAt(dig2);
            ++i;
        }
        return new String(tempArr);
    }

    public int length() {
        return this.stream.size();
    }

    public void clear() {
        this.stream.reset();
    }

    public int indexof(int value) {
        return this.indexof(value, 0);
    }

    public int indexof(int value, int fromIndex) {
        if (this.stream.size() > 0) {
            return this.stream.toString().indexOf(value, fromIndex);
        }
        return -1;
    }

    public int indexof(byte[] value) {
        return this.indexof(value, 0);
    }

    public int indexof(byte[] value, int fromIndex) {
        if (this.stream.size() > 0) {
            return this.stream.toString().indexOf(new String(value), fromIndex);
        }
        return -1;
    }

    public int indexof(char[] value) {
        return this.indexof(value, 0);
    }

    public int indexof(char[] value, int fromIndex) {
        if (this.stream.size() > 0) {
            return this.stream.toString().indexOf(new String(value), fromIndex);
        }
        return -1;
    }

    public int indexof(String value) {
        return this.indexof(value, 0);
    }

    public int indexof(String value, int fromIndex) {
        if (this.stream.size() > 0) {
            return this.stream.toString().indexOf(value, fromIndex);
        }
        return -1;
    }

    public synchronized boolean startsWith(String str) {
        return this.stream.toString().startsWith(str);
    }

    public synchronized boolean endsWith(String str) {
        return this.stream.toString().endsWith(str);
    }

    public synchronized ByteBuffer delete() {
        return this.delete(0, this.stream.size());
    }

    public synchronized ByteBuffer delete(int len) {
        return this.delete(0, len);
    }

    public synchronized ByteBuffer delete(int start, int end) {
        StringBuffer sb = new StringBuffer(this.stream.toString());
        sb.delete(start, end);
        this.clear();
        if (sb.length() > 0) {
            this.append(sb.toString());
        }
        return this;
    }

    public synchronized ByteBuffer replace(int start, int end, byte[] value) {
        StringBuffer sb = new StringBuffer(this.stream.toString());
        sb.replace(start, end, new String(value));
        this.clear();
        if (sb.length() > 0) {
            this.append(sb.toString());
        }
        return this;
    }

    public synchronized ByteBuffer substring(int start) {
        return this.substring(start, this.stream.size());
    }

    public synchronized ByteBuffer substring(int start, int end) {
        StringBuffer sb = new StringBuffer(this.stream.toString());
        return new ByteBuffer(sb.substring(start, end));
    }

    private void error(String str) {
        Logger.error(this, str);
    }
}

