/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0;

import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ByteBuffer;
import net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0.StringUtil;

public class Base64EncoderDecoder {
    private static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] BASE64_INTS = new int[128];

    static {
        int i = 0;
        while (i < BASE64_INTS.length) {
            Base64EncoderDecoder.BASE64_INTS[i] = -1;
            ++i;
        }
        i = 0;
        while (i < BASE64_CHARS.length) {
            Base64EncoderDecoder.BASE64_INTS[Base64EncoderDecoder.BASE64_CHARS[i]] = i;
            ++i;
        }
        Base64EncoderDecoder.BASE64_INTS[61] = 0;
    }

    public static String encode(byte[] data) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < data.length) {
            int b0 = data[i] & 0xFF;
            int b1 = i + 1 < data.length ? data[i + 1] & 0xFF : 0;
            int b2 = i + 2 < data.length ? data[i + 2] & 0xFF : 0;
            result.append(BASE64_CHARS[b0 >> 2]);
            result.append(BASE64_CHARS[(b0 & 3) << 4 | b1 >> 4]);
            result.append(i + 1 < data.length ? BASE64_CHARS[(b1 & 0xF) << 2 | b2 >> 6] : (char)'=');
            result.append(i + 2 < data.length ? BASE64_CHARS[b2 & 0x3F] : (char)'=');
            i += 3;
        }
        return result.toString();
    }

    public static ByteBuffer decode(String base64) {
        if ((base64 = StringUtil.RemoveStringAll(base64, "\\s")).length() % 4 != 0) {
            throw new IllegalArgumentException("Invalid Base64 input length.");
        }
        int pad = 0;
        if (base64.length() > 0 && base64.charAt(base64.length() - 1) == '=') {
            ++pad;
        }
        if (base64.length() > 1 && base64.charAt(base64.length() - 2) == '=') {
            ++pad;
        }
        int length = base64.length() * 3 / 4 - pad;
        byte[] result = new byte[length];
        int index = 0;
        int i = 0;
        while (i < base64.length()) {
            int b0 = BASE64_INTS[base64.charAt(i)];
            int b1 = BASE64_INTS[base64.charAt(i + 1)];
            int b2 = BASE64_INTS[base64.charAt(i + 2)];
            int b3 = BASE64_INTS[base64.charAt(i + 3)];
            result[index++] = (byte)(b0 << 2 | b1 >> 4);
            if (index < length) {
                result[index++] = (byte)(b1 << 4 | b2 >> 2);
            }
            if (index < length) {
                result[index++] = (byte)(b2 << 6 | b3);
            }
            i += 4;
        }
        ByteBuffer out = new ByteBuffer();
        out.append(result);
        return out;
    }
}

