/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.json.newline.proseries.dr1_0_0;

import net.controlconcepts.duet.tools.json.newline.proseries.dr1_0_0.JSONArray;
import net.controlconcepts.duet.tools.json.newline.proseries.dr1_0_0.JSONObject;

public class JSONUtil {
    private static String replaceALL(String source, char find, char replace) {
        String response = source;
        while (response.indexOf(find) >= 0) {
            response = response.replace(find, replace);
        }
        return response;
    }

    public static String getString(JSONObject json, String name) {
        String response = "";
        try {
            response = json.has(name) ? json.getString(name) : "";
        }
        catch (Exception e) {
            response = "";
        }
        return JSONUtil.replaceALL(response, '\"', '\'');
    }

    public static Object get(JSONObject json, String name) {
        Object response = null;
        try {
            response = json.has(name) ? json.get(name) : new Object();
        }
        catch (Exception e) {
            response = new Object();
        }
        return response;
    }

    public static boolean getBoolean(JSONObject json, String name) {
        try {
            return json.has(name) ? json.getBoolean(name) : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getInteger(JSONObject json, String name) {
        try {
            return json.has(name) ? json.getInt(name) : 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static int getInteger(JSONObject json, String name, int failValue) {
        try {
            return json.has(name) ? json.getInt(name) : failValue;
        }
        catch (Exception e) {
            return failValue;
        }
    }

    public static JSONArray getArray(JSONObject json, String name) {
        try {
            return json.has(name) ? json.getJSONArray(name) : new JSONArray();
        }
        catch (Exception e) {
            return new JSONArray();
        }
    }

    public static JSONObject getObject(JSONObject json, String name) {
        try {
            return json.has(name) ? json.getJSONObject(name) : new JSONObject();
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }
}

