/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0;

import java.io.ByteArrayOutputStream;
import net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0.IStruct;
import net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0.Marshall;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectRef;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectType;

public class MarshallUtil {
    private static final int VariableToString(Marshall encode, ObjectRef rBuffer, ObjectRef rPos, boolean bSkipHeader) {
        int ret = 0;
        int pos = 0;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        pos = rPos.toInt();
        if (pos > 0) {
            Object obj;
            String str = rBuffer.toString();
            if (str.length() != pos) {
                byte[] ba = new byte[pos];
                stream.write(ba, 0, pos);
                rBuffer.valueOf(String.valueOf(str) + stream.toString());
            }
            if ((obj = encode.getValue()) instanceof IStruct) {
                ret = ((IStruct)obj).binaryEncode(rBuffer, rPos);
            } else {
                ret = encode.binaryEncode(rBuffer, bSkipHeader);
                if (ret > 0) {
                    rPos.valueOf(pos + ret);
                    ret = 0;
                }
            }
        } else {
            Object obj = encode.getValue();
            ret = obj instanceof IStruct ? ((IStruct)obj).binaryEncode(rBuffer, rPos) : encode.binaryEncode(rBuffer, rPos);
        }
        return ret;
    }

    public static final int VariableToString(Marshall encode, ObjectRef rBuffer, ObjectRef rPos) {
        return MarshallUtil.VariableToString(encode, rBuffer, rPos, false);
    }

    public static final int VariableToString(Marshall[] encodeArray, ObjectRef rBuffer, ObjectRef rPos) {
        int ret = 0;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        int i = 0;
        while (i < encodeArray.length) {
            if (i == 0) {
                int len = encodeArray.length;
                if (ObjectType.STRING.equals(encodeArray[i].getType()) || ObjectType.OBJECT.equals(encodeArray[i].getType())) {
                    stream.write(-20);
                    stream.write((byte)(len >> 24));
                    stream.write((byte)(len >> 16));
                    stream.write((byte)(len >> 8));
                    stream.write((byte)(len >> 0));
                    rPos.valueOf(rPos.toInt() + 5);
                } else {
                    if (ObjectType.BOOL.equals(encodeArray[i].getType())) {
                        stream.write(-27);
                    } else if (ObjectType.BYTE.equals(encodeArray[i].getType())) {
                        stream.write(-27);
                    } else if (ObjectType.CHAR.equals(encodeArray[i].getType())) {
                        stream.write(-26);
                    } else if (ObjectType.SHORT.equals(encodeArray[i].getType())) {
                        stream.write(-26);
                    } else if (ObjectType.INTEGER.equals(encodeArray[i].getType())) {
                        stream.write(-25);
                    } else if (ObjectType.LONG.equals(encodeArray[i].getType())) {
                        stream.write(-24);
                    } else if (ObjectType.FLOAT.equals(encodeArray[i].getType())) {
                        stream.write(-25);
                    } else if (ObjectType.DOUBLE.equals(encodeArray[i].getType())) {
                        stream.write(-24);
                    }
                    stream.write((byte)(len >> 8));
                    stream.write((byte)(len >> 0));
                    rPos.valueOf(rPos.toInt() + 3);
                }
                rBuffer.valueOf(String.valueOf(rBuffer.toString()) + stream.toString());
            }
            if ((ret = MarshallUtil.VariableToString(encodeArray[i], rBuffer, rPos, true)) < 0) break;
            ++i;
        }
        return ret;
    }

    private static final int StringToVariable(Marshall decode, ObjectRef rBuffer, ObjectRef rPos, boolean bSkipHeader) {
        int ret = 0;
        int pos = rPos.toInt();
        if (pos > 0) {
            String str = rBuffer.toString();
            ObjectRef rTempBuffer = new ObjectRef(str.substring(pos, str.length()));
            Object obj = decode.getValue();
            if (obj instanceof IStruct) {
                ret = ((IStruct)obj).binaryDecode(rTempBuffer, rPos);
            } else {
                ret = decode.binaryDecode(rTempBuffer, bSkipHeader);
                if (ret > 0) {
                    rPos.valueOf(pos + ret);
                    ret = 0;
                }
            }
        } else {
            Object obj = decode.getValue();
            ret = obj instanceof IStruct ? ((IStruct)obj).binaryDecode(rBuffer, rPos) : decode.binaryDecode(rBuffer, rPos);
        }
        return ret;
    }

    public static final int StringToVariable(Marshall decode, ObjectRef rBuffer, ObjectRef rPos) {
        return MarshallUtil.StringToVariable(decode, rBuffer, rPos, false);
    }

    public static final int StringToVariable(Marshall[] decodeArray, ObjectRef rBuffer, ObjectRef rPos) {
        int ret = 0;
        int len = 0;
        String str = "";
        if (decodeArray.length > 0) {
            byte[] header;
            str = rBuffer.toString();
            if (ObjectType.STRING.equals(decodeArray[0].getType()) || ObjectType.OBJECT.equals(decodeArray[0].getType())) {
                header = str.substring(0, 5).getBytes();
                len = (header[4] << 0) + (header[3] << 8) + (header[2] << 16) + (header[1] << 24);
                rPos.valueOf(rPos.toInt() + 5);
            } else {
                header = str.substring(0, 3).getBytes();
                len = (header[2] << 0) + (header[1] << 8);
                rPos.valueOf(rPos.toInt() + 3);
            }
            int x = 0;
            while (x < len) {
                ret = MarshallUtil.StringToVariable(decodeArray[x], rBuffer, rPos, true);
                if (ret < 0) break;
                ++x;
            }
        }
        return ret;
    }

    public static final int LengthVariableToString(Marshall encode) {
        int length = 0;
        ObjectRef buffer = new ObjectRef("");
        ObjectRef rPos = new ObjectRef(0);
        if (MarshallUtil.VariableToString(encode, buffer, rPos) == 0) {
            length = rPos.toInt();
        }
        return length;
    }

    public static final int LengthVariableToString(Marshall[] encodeArray) {
        int length = 0;
        ObjectRef buffer = new ObjectRef("");
        ObjectRef rPos = new ObjectRef(0);
        if (MarshallUtil.VariableToString(encodeArray, buffer, rPos) == 0) {
            length = rPos.toInt();
        }
        return length;
    }
}

