/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0.IBinaryMarshall;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.Bits;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectRef;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectType;

public class Marshall
extends ObjectRef
implements IBinaryMarshall {
    public Marshall(boolean b) {
        super(b);
    }

    public Marshall(byte b) {
        super(b);
    }

    public Marshall(char c) {
        super(c);
    }

    public Marshall(short s) {
        super(s);
    }

    public Marshall(int i) {
        super(i);
    }

    public Marshall(long l) {
        super(l);
    }

    public Marshall(float f) {
        super(f);
    }

    public Marshall(double d) {
        super(d);
    }

    public Marshall(String str) {
        super(str);
    }

    public Marshall(Object o) {
        super(o);
    }

    public Marshall(Object o, ObjectType refType) {
        super(o, refType);
    }

    public static final boolean skipBinaryHeader(byte type) {
        return type == -27 || type == -26 || type == -25 || type == -24 || type == -23;
    }

    @Override
    public int binaryEncode(ObjectRef buffer, ObjectRef rPos) {
        int ret = this.binaryEncode(buffer, false);
        rPos.valueOf(rPos.intValue() + ret);
        return ret;
    }

    public int binaryEncode(ObjectRef buffer, boolean skipHeader) {
        int ret = 0;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Object ref = this.getValue();
        if (ref != null) {
            if (ref instanceof String) {
                return this.binaryEncodeString(buffer, false);
            }
            if (ref instanceof Boolean) {
                if (!skipHeader) {
                    stream.write(-31);
                    ret = 1;
                }
                byte[] barray = new byte[1];
                Bits.putBoolean(barray, 0, this.booleanValue());
                stream.write(barray, 0, barray.length);
                ret += barray.length;
            } else if (ref instanceof Byte) {
                if (!skipHeader) {
                    stream.write(-31);
                    ret = 1;
                }
                stream.write(this.byteValue());
                ++ret;
            } else if (ref instanceof Character) {
                if (!skipHeader) {
                    stream.write(-30);
                    ret = 1;
                }
                byte[] barray = new byte[2];
                Bits.putChar(barray, 0, this.charValue());
                stream.write(barray, 0, barray.length);
                ret += barray.length;
            } else if (ref instanceof Short) {
                if (!skipHeader) {
                    stream.write(-30);
                    ret = 1;
                }
                byte[] barray = new byte[2];
                Bits.putShort(barray, 0, this.shortValue());
                stream.write(barray, 0, barray.length);
                ret += barray.length;
            } else if (ref instanceof Integer) {
                if (!skipHeader) {
                    stream.write(-29);
                    ret = 1;
                }
                byte[] barray = new byte[4];
                Bits.putInt(barray, 0, this.intValue());
                stream.write(barray, 0, barray.length);
                ret += barray.length;
            } else if (ref instanceof Long) {
                if (!skipHeader) {
                    stream.write(-28);
                    ret = 1;
                }
                byte[] barray = new byte[8];
                Bits.putLong(barray, 0, this.longValue());
                stream.write(barray, 0, barray.length);
                ret += barray.length;
            } else if (ref instanceof Float) {
                if (!skipHeader) {
                    stream.write(-29);
                    ret = 1;
                }
                byte[] barray = new byte[4];
                Bits.putFloat(barray, 0, this.floatValue());
                stream.write(barray, 0, barray.length);
                ret += barray.length;
            } else if (ref instanceof Double) {
                if (!skipHeader) {
                    stream.write(-28);
                    ret = 1;
                }
                byte[] barray = new byte[8];
                Bits.putDouble(barray, 0, this.doubleValue());
                stream.write(barray, 0, barray.length);
                ret += barray.length;
            } else {
                ret = -1;
            }
        } else {
            ret = -1;
        }
        if (ret >= 0) {
            buffer.valueOf(String.valueOf(buffer.stringValue()) + stream.toString());
        }
        return ret;
    }

    @Override
    public int binaryDecode(ObjectRef buffer, ObjectRef rPos) {
        int ret = this.binaryDecode(buffer, false);
        rPos.valueOf(rPos.intValue() + ret);
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int binaryDecode(ObjectRef buffer, boolean skipHeader) {
        int ret = 0;
        Object ref = this.getValue();
        if (ref == null) return ret;
        try {
            if (ref == null) return -2;
            if (buffer == null) return -2;
            if (!ObjectType.STRING.equals(buffer.getType())) return -2;
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer.stringValue().getBytes());
            byte dataType = 0;
            if (!skipHeader) {
                dataType = (byte)stream.read();
                ret = 1;
            }
            if (ref instanceof String) {
                return this.binaryDecodeString(buffer);
            }
            if (ref instanceof Boolean) {
                if (dataType != 0 && dataType != -31) {
                    return -1;
                }
                if (1 > stream.available()) {
                    return -2;
                }
                byte[] barray = new byte[1];
                stream.read(barray, 0, barray.length);
                this.valueOf(Bits.getBoolean(barray, 0));
                return ret += barray.length;
            }
            if (ref instanceof Byte) {
                if (dataType != 0 && dataType != -31) {
                    return -1;
                }
                if (1 > stream.available()) {
                    return -2;
                }
                this.valueOf((byte)stream.read());
                return ++ret;
            }
            if (ref instanceof Character) {
                if (dataType != 0 && dataType != -30) {
                    return -1;
                }
                if (2 > stream.available()) {
                    return -2;
                }
                byte[] barray = new byte[2];
                stream.read(barray, 0, barray.length);
                this.valueOf(Bits.getChar(barray, 0));
                return ret += barray.length;
            }
            if (ref instanceof Short) {
                if (dataType != 0 && dataType != -30) {
                    return -1;
                }
                if (2 > stream.available()) {
                    return -2;
                }
                byte[] barray = new byte[2];
                stream.read(barray, 0, barray.length);
                this.valueOf(Bits.getShort(barray, 0));
                return ret += barray.length;
            }
            if (ref instanceof Integer) {
                if (dataType != 0 && dataType != -29) {
                    return -1;
                }
                if (4 > stream.available()) {
                    return -2;
                }
                byte[] barray = new byte[4];
                stream.read(barray, 0, barray.length);
                this.valueOf(Bits.getInt(barray, 0));
                return ret += barray.length;
            }
            if (ref instanceof Long) {
                if (dataType != 0 && dataType != -28) {
                    return -1;
                }
                if (8 > stream.available()) {
                    return -2;
                }
                byte[] barray = new byte[8];
                stream.read(barray, 0, barray.length);
                this.valueOf(Bits.getLong(barray, 0));
                return ret += barray.length;
            }
            if (ref instanceof Float) {
                if (dataType != 0 && dataType != -29) {
                    return -1;
                }
                if (4 > stream.available()) {
                    return -2;
                }
                byte[] barray = new byte[4];
                stream.read(barray, 0, barray.length);
                this.valueOf(Bits.getFloat(barray, 0));
                return ret += barray.length;
            }
            if (!(ref instanceof Double)) {
                return -1;
            }
            if (dataType != 0 && dataType != -28) {
                return -1;
            }
            if (8 > stream.available()) {
                return -2;
            }
            byte[] barray = new byte[8];
            stream.read(barray, 0, barray.length);
            this.valueOf(Bits.getDouble(barray, 0));
            return ret += barray.length;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int binaryEncodeString(ObjectRef buffer, boolean wideChar) {
        ByteArrayOutputStream stream;
        int ret;
        block14: {
            ret = 0;
            stream = new ByteArrayOutputStream();
            Object ref = this.getValue();
            if (ref != null) {
                if (ref instanceof String) {
                    String refString = this.stringValue();
                    int len = refString.length();
                    try {
                        byte[] ba1 = refString.getBytes("UTF-8");
                        if (!wideChar) {
                            if (ba1.length < 65536) {
                                len = ba1.length;
                                stream.write(-27);
                                stream.write((byte)len >> 8);
                                stream.write((byte)len);
                                stream.write(ba1, 0, len);
                                ret = len + 3;
                            } else {
                                len = ba1.length;
                                stream.write(-23);
                                byte[] barray = new byte[4];
                                Bits.putInt(barray, 0, len);
                                stream.write(barray, 0, barray.length);
                                stream.write(ba1, 0, len);
                                ret = len + 5;
                            }
                            break block14;
                        }
                        try {
                            byte[] ba2 = refString.getBytes("UTF-16BE");
                            if (ba2.length < 65536) {
                                len = ba2.length;
                                stream.write(-26);
                                stream.write((byte)len >> 8);
                                stream.write((byte)len);
                                stream.write(ba2, 0, len);
                                ret = len + 3;
                            } else {
                                ret = -1;
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            ret = -1;
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        ret = -1;
                    }
                } else {
                    ret = -1;
                }
            } else {
                ret = -1;
            }
        }
        if (ret >= 0) {
            buffer.valueOf(String.valueOf(buffer.stringValue()) + stream.toString());
        }
        return ret;
    }

    public int binaryDecodeString(ObjectRef buffer) {
        int ret = 0;
        Object ref = this.getValue();
        if (ref != null && ref instanceof String) {
            ByteArrayInputStream stream = new ByteArrayInputStream(buffer.stringValue().getBytes());
            int dataType = stream.read();
            switch ((byte)dataType) {
                case -27: {
                    if (2 > stream.available()) {
                        ret = -2;
                        break;
                    }
                    int len = stream.read();
                    int bytes = len = (len << 8) + stream.read();
                    if (bytes > stream.available()) {
                        ret = -2;
                        break;
                    }
                    byte[] data = new byte[bytes];
                    bytes = stream.read(data, 0, bytes);
                    ret = bytes + 3;
                    if (ref instanceof String) {
                        try {
                            this.valueOf(new String(data, "ISO-8859-1"));
                        }
                        catch (UnsupportedEncodingException e) {
                            ret = -1;
                        }
                        break;
                    }
                    ret = -1;
                    break;
                }
                case -26: {
                    if (2 > stream.available()) {
                        ret = -2;
                        break;
                    }
                    int len = stream.read();
                    int bytes = len = (len << 8) + stream.read();
                    if (bytes > stream.available()) {
                        ret = -2;
                        break;
                    }
                    byte[] data = new byte[bytes];
                    bytes = stream.read(data, 0, bytes);
                    ret = bytes + 3;
                    if (ref instanceof String) {
                        try {
                            this.valueOf(new String(data, "UTF-16BE"));
                        }
                        catch (UnsupportedEncodingException e) {
                            ret = -1;
                        }
                        break;
                    }
                    ret = -1;
                    break;
                }
                case -23: {
                    if (4 > stream.available()) {
                        ret = -2;
                        break;
                    }
                    byte[] barray = new byte[4];
                    stream.read(barray, 0, barray.length);
                    int bytes = Bits.getInt(barray, 0);
                    if (bytes > stream.available()) {
                        ret = -2;
                        break;
                    }
                    byte[] data = new byte[bytes];
                    bytes = stream.read(data, 0, bytes);
                    ret = bytes + barray.length + 1;
                    if (ref instanceof String) {
                        try {
                            this.valueOf(new String(data, "ISO-8859-1"));
                        }
                        catch (UnsupportedEncodingException e) {
                            ret = -1;
                        }
                        break;
                    }
                    ret = -1;
                }
            }
        }
        return ret;
    }
}

