/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0.FileManager;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectRef;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectType;

public class FileUtil {
    public static final int FILE_OK = 0;
    public static final int FILE_INVALID_HANDLE = -1;
    public static final int FILE_INVALID_FILENAME = -2;
    public static final int FILE_INVALID_IOFLAG = -3;
    public static final int FILE_INVALID_DIRECTORY = -4;
    public static final int FILE_DISK_ERROR = -5;
    public static final int FILE_INVALID_PARAMETER = -6;
    public static final int FILE_ALREADY_CLOSE = -7;
    public static final int FILE_NAME_EXISTS = -8;
    public static final int FILE_END_OF_FILE = -9;
    public static final int FILE_BUFFER_TOO_SMALL = -10;
    public static final int FILE_DISK_FULL = -11;
    public static final int FILE_DIRECTORY_NOT_LOADED = -12;
    public static final int FILE_DIRECTORY_EXISTS = -13;
    public static final int IOFLAG_READ = 1;
    public static final int IOFLAG_NEW = 2;
    public static final int IOFLAG_APPEND = 3;
    private static final String USER_DIRECTORY = "/user";

    public static final long FileClose(long lFileHandle) {
        return FileManager.getInstance().FileClose(lFileHandle);
    }

    public static final long FileCopy(String sSrcFilePath, String sDstFilePath) {
        long lRet;
        block4: {
            lRet = 0L;
            if (new File(sSrcFilePath).exists()) break block4;
            return -2L;
        }
        try {
            FileInputStream in = new FileInputStream(sSrcFilePath);
            FileOutputStream out = new FileOutputStream(sDstFilePath);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            lRet = -5L;
        }
        return lRet;
    }

    public static final long FileCreateDir(String sDirPath) {
        long lRet;
        block4: {
            lRet = 0L;
            sDirPath = FileUtil.getUserDirectory(sDirPath);
            if (!new File(sDirPath).exists()) break block4;
            return -13L;
        }
        try {
            if (!new File(sDirPath).mkdirs()) {
                lRet = -4L;
            }
        }
        catch (Exception e) {
            lRet = -5L;
        }
        return lRet;
    }

    public static final long FileDelete(String sFilePath) {
        long lRet = 0L;
        try {
            if (!new File(sFilePath).delete()) {
                lRet = -2L;
            }
        }
        catch (Exception e) {
            lRet = -5L;
        }
        return lRet;
    }

    public static final long FileDir(String sDirPath, ObjectRef rStrBuffer, ObjectRef rEntry) {
        File[] files;
        long lRet;
        block9: {
            block8: {
                block7: {
                    block6: {
                        lRet = 0L;
                        if (ObjectType.STRING.equals(rStrBuffer.getType()) && ObjectType.LONG.equals(rEntry.getType())) break block6;
                        return -6L;
                    }
                    sDirPath = FileUtil.getUserDirectory(sDirPath);
                    if (new File(sDirPath).exists()) break block7;
                    return -4L;
                }
                File dir = new File(sDirPath);
                files = dir.listFiles();
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isFile();
                    }
                };
                files = dir.listFiles(fileFilter);
                if (files.length != 0) break block8;
                return -12L;
            }
            if (rEntry.toLong() <= (long)files.length) break block9;
            return -6L;
        }
        try {
            rStrBuffer.valueOf(String.valueOf(files[rEntry.toInt()].getName()) + System.getProperty("line.separator"));
            lRet = files.length;
        }
        catch (Exception e) {
            lRet = -5L;
        }
        return lRet;
    }

    public static final long FileGetDir(ObjectRef rStrDirPath) {
        long lRet = 0L;
        rStrDirPath.valueOf(System.getProperty("user.dir"));
        return lRet;
    }

    public static final long FileOpen(String sFilePath, long lIOFlag) {
        sFilePath = FileUtil.getUserDirectory(sFilePath);
        return FileManager.getInstance().FileOpen(sFilePath, lIOFlag);
    }

    public static final long FileRead(long lFileHandle, ObjectRef rStrBuffer, long lBufLen) {
        return FileManager.getInstance().FileRead(lFileHandle, rStrBuffer, lBufLen);
    }

    public static final long FileReadLine(long lFileHandle, ObjectRef rStrBuffer, long lBufLen) {
        return FileManager.getInstance().FileReadLine(lFileHandle, rStrBuffer, lBufLen);
    }

    public static final long FileRemoveDir(String sDirPath) {
        long lRet = 0L;
        try {
            sDirPath = FileUtil.getUserDirectory(sDirPath);
            File dir = new File(sDirPath);
            if (dir.exists()) {
                if (!FileUtil.deleteDir(dir)) {
                    lRet = -5L;
                }
            } else {
                lRet = -4L;
            }
        }
        catch (Exception e) {
            lRet = -5L;
        }
        return lRet;
    }

    public static final long FileRename(String sFilePath, String sNewFileName) {
        File file2;
        File file;
        long lRet;
        block6: {
            block5: {
                lRet = 0L;
                sFilePath = FileUtil.getUserDirectory(sFilePath);
                file = new File(sFilePath);
                if (file.exists()) break block5;
                return -2L;
            }
            sNewFileName = FileUtil.getUserDirectory(sNewFileName);
            file2 = new File(sNewFileName);
            if (!file2.exists()) break block6;
            return -8L;
        }
        try {
            if (!file.renameTo(file2)) {
                lRet = -5L;
            }
        }
        catch (Exception e) {
            lRet = -5L;
        }
        return lRet;
    }

    public static final long FileSize(String sFilePath) {
        File file;
        long lRet;
        block3: {
            lRet = 0L;
            sFilePath = FileUtil.getUserDirectory(sFilePath);
            file = new File(sFilePath);
            if (file.exists()) break block3;
            return -2L;
        }
        try {
            lRet = file.length();
        }
        catch (Exception e) {
            lRet = -5L;
        }
        return lRet;
    }

    public static final long FileSize(long lFileHandle) {
        return FileManager.getInstance().FileSize(lFileHandle);
    }

    public static final long FileSeek(long lFileHandle, long lPos) {
        return FileManager.getInstance().FileSeek(lFileHandle, lPos);
    }

    public static final long FileWrite(long lFileHandle, String sBuffer, long lBufLen) {
        return FileManager.getInstance().FileWrite(lFileHandle, sBuffer, lBufLen);
    }

    public static final long FileWriteLine(long lFileHandle, String sBuffer, long lLineLen) {
        return FileManager.getInstance().FileWriteLine(lFileHandle, sBuffer, lLineLen);
    }

    public static final boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static final String getUserDirectory(String path) {
        if (path == null || path.length() == 0) {
            return USER_DIRECTORY;
        }
        String dir = "";
        dir = path.indexOf(USER_DIRECTORY) != 0 ? (path.indexOf("/") != 0 ? "/user/" + path : USER_DIRECTORY + path) : path;
        return dir;
    }
}

