/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.controlconcepts.duet.tools.io.newline.proseries.dr1_0_0.ManagedFile;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectRef;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ObjectType;

public class FileManager {
    public static final int FILE_OK = 0;
    public static final int FILE_INVALID_HANDLE = -1;
    public static final int FILE_INVALID_FILENAME = -2;
    public static final int FILE_INVALID_IOFLAG = -3;
    public static final int FILE_INVALID_DIRECTORY = -4;
    public static final int FILE_DISK_ERROR = -5;
    public static final int FILE_INVALID_PARAMETER = -6;
    public static final int FILE_ALREADY_CLOSE = -7;
    public static final int FILE_NAME_EXISTS = -8;
    public static final int FILE_END_OF_FILE = -9;
    public static final int FILE_BUFFER_TOO_SMALL = -10;
    public static final int FILE_DISK_FULL = -11;
    public static final int FILE_DIRECTORY_NOT_LOADED = -12;
    public static final int FILE_DIRECTORY_EXISTS = -13;
    public static final int IOFLAG_READ = 1;
    public static final int IOFLAG_NEW = 2;
    public static final int IOFLAG_APPEND = 3;
    private static FileManager m_instance = null;
    private Map fileMap = Collections.synchronizedMap(new HashMap());
    private Object sync = new Object();

    private FileManager() {
    }

    public static FileManager getInstance() {
        if (m_instance == null) {
            m_instance = new FileManager();
        }
        return m_instance;
    }

    public long FileOpen(String sFilePath, long lIOFlag) {
        long lRet;
        block17: {
            lRet = 0L;
            if (lIOFlag >= 1L || lIOFlag <= 3L) break block17;
            return -3L;
        }
        try {
            ManagedFile file = new ManagedFile(sFilePath, lIOFlag);
            if (lIOFlag == 1L) {
                if (!file.exists()) {
                    lRet = -2L;
                } else {
                    file.setAccessor("r");
                }
            } else if (lIOFlag == 3L) {
                if (!file.exists() && !file.createNewFile()) {
                    lRet = -5L;
                }
                if (lRet == 0L) {
                    file.setAccessor("rw");
                }
            } else {
                if (file.exists()) {
                    file.delete();
                }
                if (file.createNewFile()) {
                    file.setAccessor("rw");
                } else {
                    lRet = -5L;
                }
            }
            if (file != null && lRet == 0L) {
                this.fileMap.put(new Long(file.getHandle()), file);
                lRet = file.getHandle();
            }
        }
        catch (IOException e) {
            lRet = -5L;
        }
        catch (Exception e) {
            lRet = -5L;
        }
        if (lRet == 0L) {
            lRet = -1L;
        }
        return lRet;
    }

    public long FileClose(long lFileHandle) {
        long lRet = 0L;
        ManagedFile file = this.getFile(lFileHandle);
        lRet = file != null ? (file.getAccessor() != null ? file.setAccessor("") : -7L) : -1L;
        return lRet;
    }

    public long FileRead(long lFileHandle, ObjectRef rStrBuffer, long lBufLen) {
        long lRet;
        block13: {
            lRet = 0L;
            if (!ObjectType.STRING.equals(rStrBuffer.getType())) {
                return -6L;
            }
            RandomAccessFile access = this.getFileAccess(lFileHandle);
            if (access != null) {
                StringBuffer buffer = new StringBuffer();
                int count = 0;
                try {
                    long len = access.length();
                    if (len > 0L) {
                        if (len > lBufLen) {
                            len = lBufLen;
                        }
                        while ((long)buffer.length() < len) {
                            int temp = access.read();
                            if (temp >= 0) {
                                buffer.append((char)temp);
                                ++count;
                                continue;
                            }
                            lRet = -9L;
                            break;
                        }
                        if (buffer.length() > 0) {
                            rStrBuffer.valueOf(buffer.toString());
                            lRet = buffer.length();
                        }
                        break block13;
                    }
                    lRet = -9L;
                }
                catch (EOFException e) {
                    if (buffer.length() > 0) {
                        rStrBuffer.valueOf(buffer.toString());
                        lRet = buffer.length();
                        break block13;
                    }
                    lRet = -9L;
                }
                catch (IOException e) {
                    lRet = -5L;
                }
                catch (Exception e) {
                    lRet = -5L;
                }
            } else {
                lRet = -1L;
            }
        }
        return lRet;
    }

    public long FileReadLine(long lFileHandle, ObjectRef rStrBuffer, long lBufLen) {
        long lRet;
        block13: {
            lRet = 0L;
            if (!ObjectType.STRING.equals(rStrBuffer.getType())) {
                return -6L;
            }
            RandomAccessFile access = this.getFileAccess(lFileHandle);
            if (access != null) {
                StringBuffer buffer = new StringBuffer();
                try {
                    if (access.length() > 0L) {
                        String temp = access.readLine();
                        if (temp != null) {
                            buffer.append(temp);
                            if (lBufLen > 0L && lBufLen < (long)buffer.length()) {
                                rStrBuffer.valueOf(buffer.substring((int)lBufLen));
                            } else {
                                rStrBuffer.valueOf(buffer.toString());
                            }
                            lRet = buffer.length();
                        } else {
                            lRet = -9L;
                        }
                        break block13;
                    }
                    lRet = -9L;
                }
                catch (EOFException e) {
                    if (buffer.length() > 0) {
                        rStrBuffer.valueOf(buffer.toString());
                        lRet = buffer.length();
                        break block13;
                    }
                    lRet = -9L;
                }
                catch (IOException e) {
                    lRet = -5L;
                }
                catch (Exception e) {
                    lRet = -5L;
                }
            } else {
                lRet = -1L;
            }
        }
        return lRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long FileSeek(long lFileHandle, long lPos) {
        long lRet;
        block9: {
            lRet = 0L;
            RandomAccessFile access = this.getFileAccess(lFileHandle);
            if (access != null) {
                try {
                    if (access.length() >= lPos) {
                        Object object = this.sync;
                        synchronized (object) {
                            access.seek(lPos);
                        }
                        lRet = access.getFilePointer();
                        break block9;
                    }
                    lRet = -6L;
                }
                catch (IOException e) {
                    lRet = -5L;
                }
                catch (Exception e) {
                    lRet = -5L;
                }
            } else {
                lRet = -1L;
            }
        }
        return lRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long FileWrite(long lFileHandle, String sBuffer, long lBufLen) {
        long lRet = 0L;
        if (sBuffer.length() == 0) {
            return -6L;
        }
        RandomAccessFile access = this.getFileAccess(lFileHandle);
        if (access != null) {
            try {
                String sub = sBuffer;
                if ((long)sBuffer.length() > lBufLen) {
                    sub = sBuffer.substring((int)lBufLen);
                }
                Object object = this.sync;
                synchronized (object) {
                    access.writeBytes(sub);
                }
                lRet = sub.getBytes().length;
            }
            catch (IOException e) {
                lRet = -5L;
            }
            catch (Exception e) {
                lRet = -5L;
            }
        } else {
            lRet = -1L;
        }
        return lRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long FileWriteLine(long lFileHandle, String sBuffer, long lLineLen) {
        long lRet = 0L;
        if (sBuffer.length() == 0) {
            return -6L;
        }
        RandomAccessFile access = this.getFileAccess(lFileHandle);
        if (access != null) {
            try {
                String sub = sBuffer;
                if ((long)sBuffer.length() > lLineLen) {
                    sub = sBuffer.substring((int)lLineLen);
                }
                sub = String.valueOf(sub) + System.getProperty("line.separator");
                Object object = this.sync;
                synchronized (object) {
                    access.writeBytes(sub);
                }
                lRet = sub.getBytes().length;
            }
            catch (IOException e) {
                lRet = -5L;
            }
            catch (Exception e) {
                lRet = -5L;
            }
        } else {
            lRet = -1L;
        }
        return lRet;
    }

    public long FileSize(long lFileHandle) {
        long lRet = 0L;
        ManagedFile file = this.getFile(lFileHandle);
        lRet = file != null ? file.length() : -1L;
        return lRet;
    }

    private ManagedFile getFile(long lFileHandle) {
        ManagedFile file = null;
        Long lKey = new Long(lFileHandle);
        if (this.fileMap.containsKey(lKey)) {
            file = (ManagedFile)this.fileMap.get(lKey);
        }
        return file;
    }

    private RandomAccessFile getFileAccess(long lFileHandle) {
        RandomAccessFile access = null;
        ManagedFile file = this.getFile(lFileHandle);
        if (file != null) {
            access = file.getAccessor();
        }
        return access;
    }
}

