/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.tools.comm.newline.proseries.dr1_0_0;

import com.amx.duet.core.master.netlinx.DPS;
import com.amx.duet.core.master.netlinx.Event;
import com.amx.duet.core.master.netlinx.Level;
import com.amx.duet.core.util.FormatUtil;
import com.amx.duet.core.util.NetLinxSystemUtil;
import com.amx.duet.da.NetLinxDevice;
import com.amx.duet.da.SerialDevice;
import com.amx.duet.devicesdk.base.AdvancedEvent;
import com.amx.duet.devicesdk.base.Module;
import com.amx.duet.devicesdk.base.ModuleComponentEvent;
import com.amx.duet.util.Timeline;
import com.amx.duet.util.TimelineListener;
import com.amx.duet.util.Timer;
import com.amx.duet.util.TimerListener;
import java.io.File;
import java.util.Properties;
import net.controlconcepts.duet.tools.comm.newline.proseries.dr1_0_0.IDeviceListener;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ByteBuffer;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.Logger;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ValidateUtil;
import net.controlconcepts.duet.tools.net.tcp.newline.proseries.dr1_0_0.SocketConnection;
import net.controlconcepts.duet.tools.net.tcp.newline.proseries.dr1_0_0.SocketConnectionListener;
import net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0.NumericUtil;

public class DeviceUtil
implements TimelineListener,
TimerListener,
SocketConnectionListener {
    public static final int POLL_TIME_MIN = 10000;
    public static final int POLL_TIME_MAX = 300000;
    public static final int RECONNECT_TIME_MIN = 10000;
    public static final int RECONNECT_TIME_MAX = 60000;
    public static final int DEFAULT_POLL_TIME = 10000;
    public static final int DEFAULT_CONNECT_TIME = 15000;
    public static final int DEFAULT_QUEUE_TIME = 200;
    public static final int DEFAULT_HEART_TIME = 30000;
    public static final int DEFAULT_TIMEOUT_COUNT = 3;
    public static final String BAUD_RATE = "Baud_Rate";
    public static final String PASSWORD = "Password";
    public static final String USERNAME = "User_Name";
    public static final String POLL_TIME = "Poll_Time";
    public static final String DEVICE_ID = "Device_ID";
    public static final String IP_PORT = "Port";
    public static final String IP_ADDRESS = "IP_Address";
    public static final String TIMEOUT_COUNT = "Timeout_Count";
    public static final String RECONNECT_TIME = "Reconnect_Time";
    public static final String SYSTEM_DIAGNOSTIC = "System_Diagnostic";
    public static final int IP_ONLY = 1;
    public static final int IP_SERIAL = 2;
    public static final int SERIAL_ONLY = 3;
    public static final int MIN_LVL = 0;
    public static final int MAX_LVL = 255;
    public static final int MIN_ADJUST = -255;
    public static final int MAX_ADJUST = 255;
    public static final int DEBUG = 4;
    public static final int INFO = 4;
    public static final int WARNING = 4;
    public static final int ERROR = 4;
    private Module m_mod = null;
    private boolean m_bOnline = false;
    private boolean m_bInitialized = false;
    private NetLinxDevice m_dvDevice = null;
    private SocketConnection ipConnection = null;
    private boolean m_bIPControlled = false;
    private boolean m_bConnecting = false;
    private long[] lReConnect = new long[]{15000L};
    private Timeline tReConnectTimeline = null;
    private long[] lDeQueTime = new long[]{200L};
    private Timeline tDeQueTimeline = null;
    private long[] lPollTime = new long[]{10000L};
    private Timeline tPollTimeline = null;
    private long[] lHeartBeatTime = new long[]{30000L};
    private Timeline tHeartBeatTimeline = null;
    private static final long TIME_OUT = 5000L;
    private Timer tResponseTimer = null;
    private int nMAX_TIMEOUT = 3;
    private int m_nTimeoutCount = 0;
    private boolean bQueueTimePaused = false;
    private boolean bQueueLock = false;
    private Object sync = new Object();
    private String[] m_rates = null;
    private int m_baud = 9600;
    private String m_ipAddress = "255.255.255.255";
    Properties m_props = null;
    private boolean bDisposing = false;

    public DeviceUtil() {
    }

    public DeviceUtil(Module mod) {
        this.setCommonDevice(mod);
    }

    public DeviceUtil(Module mod, NetLinxDevice nd, Properties props) {
        this.setCommonDevice(mod);
        this.m_props = props;
        this.initialize(nd);
    }

    protected void initialize(NetLinxDevice nd) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return;
        }
        this.m_mod.log(4, "DeviceUtil.initialize(nd) called");
        try {
            int nDeviceType = this.isIPControlled();
            if (nDeviceType == 1) {
                this.m_bIPControlled = true;
            } else if (nDeviceType == 2) {
                if (nd != null && ValidateUtil.isValidDPS(nd.getDPS())) {
                    this.setNetLinxDevice(nd);
                } else {
                    this.m_bIPControlled = true;
                }
            } else if (nDeviceType == 3) {
                this.setNetLinxDevice(nd);
            }
            this.tHeartBeatTimeline = new Timeline((TimelineListener)this, this.lHeartBeatTime, true, -1);
            this.tDeQueTimeline = new Timeline((TimelineListener)this, this.lDeQueTime, true, -1);
            this.tPollTimeline = new Timeline((TimelineListener)this, this.lPollTime, true, -1);
            if (this.isIPControlEnabled()) {
                this.setProperty(RECONNECT_TIME, NumericUtil.ltoa(15000L));
                this.tReConnectTimeline = new Timeline((TimelineListener)this, this.lReConnect, true, -1);
                this.tReConnectTimeline.start();
            }
            this.setProperty(POLL_TIME, NumericUtil.ltoa(10000L));
            this.setProperty(TIMEOUT_COUNT, NumericUtil.itoa(3));
        }
        catch (Exception e) {
            this.error("Exception in DeviceUtil initialize() - " + e.toString());
            e.printStackTrace();
        }
    }

    public void setCommonDevice(Module mod) {
        this.m_mod = mod;
    }

    public Module getCommonDevice() {
        return this.m_mod;
    }

    public boolean isDeviceOnLine() {
        return this.m_bOnline;
    }

    public boolean isDataInitialized() {
        return this.m_bInitialized;
    }

    public void setNetLinxDevice(NetLinxDevice nd) {
        this.m_dvDevice = nd;
    }

    public NetLinxDevice getNetLinxDevice() {
        return this.m_dvDevice;
    }

    public void setMaxTimeout(int count) {
        this.nMAX_TIMEOUT = count;
    }

    public int getMaxTimeout() {
        return this.nMAX_TIMEOUT;
    }

    public void setTimeoutCount(int count) {
        this.m_nTimeoutCount = count;
    }

    public void incrementTimeout() {
        ++this.m_nTimeoutCount;
    }

    public int getTimeoutCount() {
        return this.m_nTimeoutCount;
    }

    public void setValidBaudRates(String[] rates) {
        this.m_rates = rates;
    }

    public String[] getValidBaudRates() {
        return this.m_rates;
    }

    public void setDefaultBaudRate(int rate) {
        this.m_baud = rate;
        this.setProperty(BAUD_RATE, NumericUtil.itoa(this.m_baud));
    }

    public void setDefaultIPAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
        this.setProperty(IP_ADDRESS, ipAddress);
    }

    public void setDefaultIPAddress(String ipAddress, int ipPort) {
        this.m_ipAddress = ipAddress;
        this.setProperty(IP_ADDRESS, ipAddress);
        this.setProperty(IP_PORT, String.valueOf(ipPort));
    }

    public boolean isIPControlEnabled() {
        return this.m_bIPControlled;
    }

    private String getProperty(String key) {
        block3: {
            try {
                if (this.m_mod != null) {
                    String value = this.m_mod.getProperty(key);
                    this.m_mod.log(4, "getProperty(" + key + ") = " + value);
                    return value;
                }
            }
            catch (Exception e) {
                if (this.m_props == null) break block3;
                String value = this.m_props.getProperty(key);
                this.m_mod.log(4, "getProperty(" + key + ") = " + value);
                return value;
            }
        }
        return null;
    }

    private void setProperty(String key, String value) {
        block3: {
            try {
                if (this.m_mod != null) {
                    this.m_mod.setProperty(key, value);
                    this.m_mod.log(4, "setProperty(" + key + "," + value + ")");
                }
            }
            catch (Exception e) {
                if (this.m_props == null) break block3;
                this.m_props.setProperty(key, value);
                this.m_mod.log(4, "setProperty(" + key + "," + value + ")");
            }
        }
    }

    public String getPropertyKey(String key) {
        if (key.compareToIgnoreCase(BAUD_RATE) == 0) {
            key = BAUD_RATE;
        } else if (key.compareToIgnoreCase(IP_ADDRESS) == 0) {
            key = IP_ADDRESS;
        } else if (key.compareToIgnoreCase("IP-Address") == 0) {
            key = IP_ADDRESS;
        } else if (key.compareToIgnoreCase(IP_PORT) == 0) {
            key = IP_PORT;
        } else if (key.compareToIgnoreCase(POLL_TIME) == 0) {
            key = POLL_TIME;
        } else if (key.compareToIgnoreCase(DEVICE_ID) == 0) {
            key = DEVICE_ID;
        } else if (key.compareToIgnoreCase(TIMEOUT_COUNT) == 0) {
            key = TIMEOUT_COUNT;
        } else if (key.compareToIgnoreCase(RECONNECT_TIME) == 0) {
            key = RECONNECT_TIME;
        } else if (key.compareToIgnoreCase(SYSTEM_DIAGNOSTIC) == 0) {
            key = SYSTEM_DIAGNOSTIC;
        }
        return key;
    }

    public Property validateProperty(String key, String value) {
        Property prop = new Property();
        if (key.compareToIgnoreCase(BAUD_RATE) == 0) {
            prop.value = ValidateUtil.validateBaudRate(value, this.getValidBaudRates(), NumericUtil.itoa(this.m_baud));
            prop.key = BAUD_RATE;
        } else if (key.compareToIgnoreCase(IP_ADDRESS) == 0) {
            prop.value = value;
            if (!ValidateUtil.isValidIP(value)) {
                prop.value = this.m_ipAddress;
            }
            prop.key = IP_ADDRESS;
        } else if (key.compareToIgnoreCase("IP-Address") == 0) {
            prop.value = value;
            if (!ValidateUtil.isValidIP(value)) {
                prop.value = this.m_ipAddress;
            }
            prop.key = IP_ADDRESS;
        } else if (key.compareToIgnoreCase(IP_PORT) == 0) {
            prop.value = value;
            prop.key = IP_PORT;
        }
        if (key.compareToIgnoreCase(POLL_TIME) == 0) {
            prop.value = ValidateUtil.validatePollTime(value, 10000L, 300000L, 10000L);
            prop.key = POLL_TIME;
        } else if (key.compareToIgnoreCase(DEVICE_ID) == 0) {
            prop.value = ValidateUtil.validateDeviceID(value, 0, 255, "00");
            prop.key = DEVICE_ID;
        } else if (key.compareToIgnoreCase(TIMEOUT_COUNT) == 0) {
            prop.value = ValidateUtil.validateTimeoutCount(value, this.getMaxTimeout(), 3);
            prop.key = TIMEOUT_COUNT;
        } else if (key.compareToIgnoreCase(RECONNECT_TIME) == 0) {
            prop.value = ValidateUtil.validateReconnnectTime(value, 10000L, 60000L, 15000L);
            prop.key = RECONNECT_TIME;
        } else if (key.compareToIgnoreCase(SYSTEM_DIAGNOSTIC) == 0) {
            if (NumericUtil.atoi(value) == 1) {
                this.m_bOnline = this.setOnlineState(true);
                this.m_bInitialized = this.setDataInitializedState(true);
            }
            prop.value = value;
            prop.key = SYSTEM_DIAGNOSTIC;
        } else {
            prop.value = value;
            prop.key = key;
        }
        return prop;
    }

    public void refresh() {
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.refresh() called");
            this.m_mod.processDeviceOnLineEvent(new ModuleComponentEvent((Object)this.m_mod, this.isDeviceOnLine(), 1));
            this.m_mod.processDataInitializedEvent(new ModuleComponentEvent((Object)this.m_mod, this.isDataInitialized(), 1));
        }
    }

    public void reinitialize() {
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.reinitialize() called");
        }
        this.killResponseTimer();
        if (this.tHeartBeatTimeline != null) {
            this.tHeartBeatTimeline.kill();
        }
        if (this.tDeQueTimeline != null) {
            this.tDeQueTimeline.kill();
        }
        if (this.tPollTimeline != null) {
            this.tPollTimeline.kill();
        }
        if (this.isIPControlEnabled() && this.tReConnectTimeline != null) {
            this.tReConnectTimeline.kill();
        }
        this.setMaxTimeout(NumericUtil.atoi(this.getProperty(TIMEOUT_COUNT)));
        if (this.isIPControlEnabled() && this.isConnected()) {
            this.ipClose();
        }
        if (this.isDataInitialized()) {
            this.m_bInitialized = this.setDataInitializedState(false);
        }
        this.lockQueue(false);
        this.bQueueTimePaused = false;
    }

    public void dispose() {
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.dispose() called");
        }
        this.bDisposing = true;
        try {
            try {
                if (this.isIPControlEnabled() && this.ipConnection != null) {
                    this.ipClose();
                    this.ipConnection.dispose();
                    this.ipConnection = null;
                }
            }
            catch (Exception e) {
                System.out.println("Exception in dispose()" + e.toString());
                e.printStackTrace();
                this.killResponseTimer();
                if (this.tHeartBeatTimeline != null) {
                    this.tHeartBeatTimeline.kill();
                    this.tHeartBeatTimeline = null;
                }
                if (this.tDeQueTimeline != null) {
                    this.tDeQueTimeline.kill();
                    this.tDeQueTimeline = null;
                }
                if (this.tPollTimeline != null) {
                    this.tPollTimeline.kill();
                    this.tPollTimeline = null;
                }
                if (this.isIPControlEnabled() && this.tReConnectTimeline != null) {
                    this.tReConnectTimeline.kill();
                    this.tReConnectTimeline = null;
                }
            }
        }
        finally {
            this.killResponseTimer();
            if (this.tHeartBeatTimeline != null) {
                this.tHeartBeatTimeline.kill();
                this.tHeartBeatTimeline = null;
            }
            if (this.tDeQueTimeline != null) {
                this.tDeQueTimeline.kill();
                this.tDeQueTimeline = null;
            }
            if (this.tPollTimeline != null) {
                this.tPollTimeline.kill();
                this.tPollTimeline = null;
            }
            if (this.isIPControlEnabled() && this.tReConnectTimeline != null) {
                this.tReConnectTimeline.kill();
                this.tReConnectTimeline = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockQueue(boolean bLock) {
        if (this.m_mod != null) {
            this.m_mod.log(4, "lockQueue(" + bLock + ")");
        }
        Object object = this.sync;
        synchronized (object) {
            this.bQueueLock = bLock;
        }
    }

    public boolean isQueueLocked() {
        return this.bQueueLock;
    }

    public boolean ipConnect() {
        if (this.bDisposing) {
            return false;
        }
        if (this.m_mod == null) {
            this.error("Common device not found");
            return false;
        }
        if (this.isConnected() || this.m_bConnecting) {
            return false;
        }
        this.m_mod.log(4, "connecting socket...");
        this.m_bConnecting = true;
        String ipAddress = this.getIPAddress(IP_ADDRESS);
        int nPort = NumericUtil.atoi(this.getProperty(IP_PORT));
        if (this.ipConnection == null) {
            this.ipConnection = new SocketConnection(ipAddress, nPort, 1024, (SocketConnectionListener)this);
        } else {
            this.ipConnection.setAddressAndPort(ipAddress, nPort);
        }
        return this.ipConnection.connect();
    }

    public void ipClose() {
        if (this.m_mod != null) {
            this.m_mod.log(4, "closing socket...");
        }
        if (this.isConnected()) {
            this.ipConnection.disconnect();
        }
    }

    public boolean isConnected() {
        boolean connected = false;
        if (this.ipConnection != null) {
            connected = this.ipConnection.isConnected();
        }
        return connected;
    }

    public void reconnect() {
        if (this.bDisposing) {
            return;
        }
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.reconnect() called");
        }
        if (this.isIPControlEnabled()) {
            this.lReConnect[0] = NumericUtil.atol(this.getProperty(RECONNECT_TIME));
            this.tReConnectTimeline.reload(this.lReConnect);
            this.tReConnectTimeline.start();
        }
    }

    public void handleOnlineEvent() {
        if (this.bDisposing) {
            return;
        }
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.handleOnlineEvent() called");
        }
        if (!this.isIPControlEnabled()) {
            if (this.m_dvDevice == null) {
                this.error("NetLinxDevice not found");
                return;
            }
            if (this.m_mod instanceof IDeviceListener) {
                ((IDeviceListener)this.m_mod).setCommPort();
            }
        }
        if (this.isIPControlEnabled()) {
            if (this.tReConnectTimeline != null) {
                this.tReConnectTimeline.kill();
            }
            this.m_bConnecting = false;
        }
        if (this.tDeQueTimeline != null) {
            this.tDeQueTimeline.start();
        }
        if (this.tHeartBeatTimeline != null) {
            this.tHeartBeatTimeline.start();
        }
    }

    public void handleOfflineEvent() {
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.handleOfflineEvent() called");
        }
        if (this.isDeviceOnLine()) {
            this.incrementTimeout();
            if (this.getTimeoutCount() >= this.getMaxTimeout()) {
                if (this.m_mod != null) {
                    this.m_mod.log(4, "Setting device offline.");
                }
                this.setOnlineState(false);
                this.setTimeoutCount(0);
            }
        }
        if (this.isDataInitialized()) {
            this.setDataInitializedState(false);
        }
        if (this.isIPControlEnabled()) {
            if (this.m_mod != null) {
                this.m_mod.log(4, "Socket closed by peer");
            }
            this.m_bConnecting = false;
        }
        if (this.m_mod != null) {
            this.m_mod.reinitialize();
        }
    }

    public void handleErrorEvent(int error) {
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.handleErrorEvent(" + error + ")");
        }
        switch (error) {
            case -1: {
                if (this.m_mod == null) break;
                this.m_mod.log(4, "handleErrorEvent: socket timed out");
                break;
            }
            case -4: {
                if (this.m_mod == null) break;
                this.m_mod.log(4, "handleErrorEvent: socket failed to connect");
                break;
            }
            default: {
                if (this.m_mod == null) break;
                this.m_mod.log(4, "handleErrorEvent: unknown error - status [" + error + "]");
            }
        }
        if (this.isIPControlEnabled() && this.isConnected()) {
            this.ipClose();
        } else if (this.m_mod instanceof IDeviceListener) {
            ((IDeviceListener)this.m_mod).handleOfflineEvent();
        }
    }

    public void handleTimelineEvent(Timeline timeline) {
        if (timeline == this.tDeQueTimeline) {
            if (this.m_mod instanceof IDeviceListener) {
                ((IDeviceListener)this.m_mod).deQueue();
            }
        } else if (timeline == this.tPollTimeline) {
            if (this.m_mod instanceof IDeviceListener) {
                ((IDeviceListener)this.m_mod).pollEvent();
            }
        } else if (timeline == this.tHeartBeatTimeline) {
            if (this.m_mod instanceof IDeviceListener) {
                ((IDeviceListener)this.m_mod).heartbeatEvent();
            }
            this.startResponseTimer();
        } else if (timeline == this.tReConnectTimeline) {
            if (this.isConnected() || this.m_bConnecting) {
                return;
            }
            this.ipConnect();
        }
    }

    public void handleTimerEvent(Timer timer) {
        if (timer == this.tResponseTimer) {
            if (this.m_mod != null) {
                this.m_mod.log(4, "Response timer timed out.");
            }
            this.tResponseTimer = null;
            this.lockQueue(false);
            if (this.isDeviceOnLine()) {
                this.incrementTimeout();
                if (this.getTimeoutCount() >= this.getMaxTimeout()) {
                    if (this.m_mod != null) {
                        this.m_mod.log(4, "Setting device offline.");
                    }
                    this.setOnlineState(false);
                    this.setTimeoutCount(0);
                }
            }
            if (this.m_mod != null) {
                this.m_mod.reinitialize();
            }
        }
    }

    @Override
    public void handleReceive(int bytesReceived, byte[] data) {
        if (this.m_mod != null) {
            this.m_mod.processPassBackEvent(new ModuleComponentEvent((Object)this.m_mod, (Object)new String(data, 0, bytesReceived), 1));
        }
        if (this.m_mod instanceof IDeviceListener) {
            ((IDeviceListener)this.m_mod).handleIncomingData(bytesReceived, data);
        }
    }

    @Override
    public void handleSocketStatus(int status) {
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.handleSocketStatus(" + status + ") called");
        }
        switch (status) {
            case -2: {
                if (!(this.m_mod instanceof IDeviceListener)) break;
                ((IDeviceListener)this.m_mod).handleOfflineEvent();
                break;
            }
            case 1: {
                if (!(this.m_mod instanceof IDeviceListener)) break;
                ((IDeviceListener)this.m_mod).handleOnlineEvent();
                break;
            }
            default: {
                if (!(this.m_mod instanceof IDeviceListener)) break;
                ((IDeviceListener)this.m_mod).handleErrorEvent(status);
            }
        }
    }

    public void killResponseTimer() {
        if (this.tResponseTimer != null) {
            this.tResponseTimer = this.stopTimer(this.tResponseTimer, "tResponseTimer");
        }
    }

    public void startResponseTimer() {
        if (this.tResponseTimer == null) {
            this.tResponseTimer = this.startTimer("tResponseTimer", 5000L);
        }
    }

    public void pauseQueueTimeline() {
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.pauseQueueTimeline() called");
        }
        if (this.tDeQueTimeline != null && !this.bQueueTimePaused) {
            this.tDeQueTimeline.pause();
            this.bQueueTimePaused = true;
        }
    }

    public void restartQueueTimeline() {
        if (this.m_mod != null) {
            this.m_mod.log(4, "DeviceUtil.restartQueueTimeline() called");
        }
        if (this.tDeQueTimeline != null && this.bQueueTimePaused) {
            this.tDeQueTimeline.restart();
            this.bQueueTimePaused = false;
        }
    }

    public void startPolling() {
        if (this.bDisposing) {
            return;
        }
        if (this.tPollTimeline != null && this.m_mod != null) {
            this.lPollTime[0] = NumericUtil.atol(this.getProperty(POLL_TIME));
            this.tPollTimeline.reload(this.lPollTime);
            this.tPollTimeline.start();
            this.m_mod.log(4, "Polling started...");
        }
    }

    public void fnSendStringFeedback(String msg, AdvancedEvent advEv, int zone, Object device) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return;
        }
        String response = new String(msg);
        Event ev = new Event();
        if (device != null) {
            ev.dps = ((NetLinxDevice)device).getDPS();
        }
        ev.type = 64;
        ev.dataType = 9;
        ev.dataValue = response.getBytes();
        ModuleComponentEvent e = new ModuleComponentEvent((Object)this.m_mod, advEv, ev, zone);
        this.m_mod.processAdvancedEvent(e);
    }

    public void fnSendLevelFeedback(int levelID, int levelValue, AdvancedEvent advEv, int zone, Object device) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return;
        }
        Event ev = new Event();
        if (device != null) {
            ev.dps = ((NetLinxDevice)device).getDPS();
        }
        ev.idx = levelID;
        ev.type = 16;
        ev.dataType = 1;
        ev.dataValue = new Level((long)levelValue);
        ModuleComponentEvent e = new ModuleComponentEvent((Object)this.m_mod, advEv, ev, zone);
        this.m_mod.processAdvancedEvent(e);
    }

    public void fnSendChannelFeedback(int chanID, boolean chanValue, AdvancedEvent advEv, int zone, Object device) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return;
        }
        Event ev = new Event();
        if (device != null) {
            ev.dps = ((NetLinxDevice)device).getDPS();
        }
        ev.idx = chanID;
        ev.type = chanValue ? 4 : 8;
        ModuleComponentEvent e = new ModuleComponentEvent((Object)this.m_mod, advEv, ev, zone);
        this.m_mod.processAdvancedEvent(e);
    }

    public String fnGetBaudRate(String sDefaultRate, String[] sValidRates) {
        String newrate;
        if (this.m_mod == null) {
            this.error("Common device not found");
            return null;
        }
        String rate = this.getProperty(BAUD_RATE);
        if (!rate.equals(newrate = ValidateUtil.validateBaudRate(rate, sValidRates, sDefaultRate))) {
            this.m_mod.log(4, "Changing Baud rate to " + newrate);
            this.setProperty(BAUD_RATE, newrate);
        }
        return newrate;
    }

    public byte fnGetDeviceID(String sDefaultID, int nMinID, int nMaxID) {
        String newID;
        if (this.m_mod == null) {
            this.error("Common device not found");
            return 0;
        }
        String id = this.getProperty(DEVICE_ID);
        if (!id.equals(newID = ValidateUtil.validateDeviceID(id, nMinID, nMaxID, sDefaultID))) {
            this.m_mod.log(4, "Invalid value for the Device ID Property. Setting default.");
            this.setProperty(DEVICE_ID, newID);
        }
        return (byte)NumericUtil.ATOI(newID);
    }

    public boolean setOnlineState(boolean state) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return false;
        }
        if (this.m_mod.isDeviceOnLine() != state) {
            this.m_bOnline = state;
            this.m_mod.processDeviceOnLineEvent(new ModuleComponentEvent((Object)this.m_mod, state, 1));
        }
        return state;
    }

    public boolean setDataInitializedState(boolean state) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return false;
        }
        if (this.m_mod.isDataInitialized() != state) {
            this.m_bInitialized = state;
            this.m_mod.processDataInitializedEvent(new ModuleComponentEvent((Object)this.m_mod, state, 1));
        }
        return state;
    }

    public String getIPAddress(String defaultIP) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return null;
        }
        String addr = this.getProperty(IP_ADDRESS);
        if (addr != null && addr.length() > 0) {
            return addr;
        }
        addr = this.getProperty("IP-Address");
        if (addr != null && addr.length() > 0) {
            return addr;
        }
        if (this.m_mod != null) {
            this.m_mod.log(4, "Invalid value for the IP Address Property. Setting default.");
        }
        this.setProperty(IP_ADDRESS, defaultIP);
        return defaultIP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int isIPControlled() throws IllegalArgumentException, NullPointerException {
        int nIPType = 0;
        if (this.m_mod == null) throw new NullPointerException("Module properties unavailable!");
        String deviceType = this.getProperty("Device-Category");
        if (deviceType == null) throw new NullPointerException("Device-Category not defined!");
        if (deviceType.length() <= 0) throw new IllegalArgumentException("Device-Category not defined!");
        if ((deviceType = deviceType.toUpperCase()).equals("IP")) {
            return 1;
        }
        if (deviceType.indexOf("IP") > -1 && (deviceType.indexOf("SERIAL") > -1 || deviceType.indexOf("RS-") > -1)) {
            String ipAddress = this.getProperty(IP_ADDRESS);
            if (ipAddress == null || ipAddress.length() == 0) {
                ipAddress = this.getProperty("IP-Address");
            }
            if (!ValidateUtil.isValidIP(ipAddress)) return 2;
            return 1;
        }
        if (deviceType.indexOf("SERIAL") > -1) return 3;
        if (deviceType.indexOf("RS-") > -1) {
            return 3;
        }
        if (deviceType.indexOf("IP") < 0) return nIPType;
        String ipAddress = this.getProperty(IP_ADDRESS);
        if (ipAddress == null || ipAddress.length() == 0) {
            ipAddress = this.getProperty("IP-Address");
        }
        if (!ValidateUtil.isValidIP(ipAddress)) return nIPType;
        return 1;
    }

    public boolean isSerialControlled(NetLinxDevice nd) throws NullPointerException {
        boolean bSerial = false;
        if (nd != null) {
            if (nd instanceof SerialDevice) {
                bSerial = true;
            }
            if (!bSerial) {
                bSerial = ValidateUtil.isValidDPS(nd.getDPS());
            }
        } else {
            throw new NullPointerException("Invalid NetLinx Device passed in!");
        }
        return bSerial;
    }

    public boolean isDynamicDevice() {
        boolean bDynamic = false;
        if (this.m_mod != null) {
            String dynamicType = this.getProperty("Dynamic-Type");
            if (dynamicType != null && dynamicType.length() > 0) {
                bDynamic = true;
            }
        } else {
            throw new NullPointerException("Module properties unavailable!");
        }
        return bDynamic;
    }

    public DPS getVirtualDPS() {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return null;
        }
        String vdStr = this.getProperty("Duet-Device");
        if (vdStr == null || vdStr.length() == 0) {
            this.error("Virtual device not found");
            return null;
        }
        DPS virtualDPS = new DPS(vdStr);
        return virtualDPS;
    }

    public int getAdvancedIndex(DPS eventDPS) {
        int index = 0;
        DPS virtualDPS = this.getVirtualDPS();
        if (eventDPS.getDevice() == virtualDPS.getDevice() || eventDPS.getSystem() == virtualDPS.getSystem()) {
            index = eventDPS.getPort();
        }
        return index;
    }

    public boolean IsFileNameValid(String strFileName) {
        String strReservedName = "";
        String strmsg = "";
        if (strFileName.indexOf("?") != -1 || strFileName.indexOf("\"") != -1 || strFileName.indexOf(">") != -1 || strFileName.indexOf("<") != -1 || strFileName.indexOf("|") != -1 || strFileName.indexOf("/") != -1 || strFileName.indexOf("*") != -1) {
            strmsg = "The " + strFileName + " has invalid characters.";
            System.out.println(strmsg);
            return false;
        }
        File splitFile = new File(strFileName);
        String strName = splitFile.getName();
        String strMsgFormat = "%s is a reserved device name and cannot be used for a files.";
        int i = 0;
        while (i < 10) {
            strReservedName = "COM" + (i + 1);
            if (strName.compareToIgnoreCase(strReservedName) == 0) {
                Object[] msgList = new Object[3];
                msgList[0] = strReservedName;
                strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
                System.out.println(strmsg);
                return false;
            }
            strReservedName = "LPT" + (i + 1);
            if (strName.compareToIgnoreCase(strReservedName) == 0) {
                Object[] msgList = new Object[3];
                msgList[0] = strReservedName;
                strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
                System.out.println(strmsg);
                return false;
            }
            ++i;
        }
        if (strName.compareToIgnoreCase("NUL") == 0) {
            Object[] msgList = new Object[3];
            msgList[0] = new String("NUL");
            strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
            System.out.println(strmsg);
            return false;
        }
        if (strName.compareToIgnoreCase("PRN") == 0) {
            Object[] msgList = new Object[3];
            msgList[0] = new String("PRN");
            strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
            System.out.println(strmsg);
            return false;
        }
        if (strName.compareToIgnoreCase("AUX") == 0) {
            Object[] msgList = new Object[3];
            msgList[0] = new String("AUX");
            strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
            System.out.println(strmsg);
            return false;
        }
        if (strName.compareToIgnoreCase("CON") == 0) {
            Object[] msgList = new Object[3];
            msgList[0] = new String("CON");
            strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
            System.out.println(strmsg);
            return false;
        }
        return true;
    }

    public Timer startTimer(String name, long lTime) {
        if (this.bDisposing) {
            return null;
        }
        if (this.m_mod != null) {
            this.m_mod.log(4, "startTimer(" + name + ", " + lTime + ")");
        }
        Timer timer = new Timer((TimerListener)this, lTime);
        timer.start();
        return timer;
    }

    public Timer stopTimer(Timer timer, String name) {
        if (timer != null) {
            if (this.m_mod != null) {
                this.m_mod.log(4, "stopTimer(" + name + ")");
            }
            timer.cancel();
            timer = null;
        }
        return timer;
    }

    public void setCTSEnable(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("CTSPSH");
        }
    }

    public void setBaud(String baud) {
        this.m_dvDevice.sendCommand("SET BAUD " + baud);
    }

    public void setBaud(String baud, boolean temporary) {
        if (NetLinxSystemUtil.getDeviceID((DPS)this.m_dvDevice.getDPS()) > 255 && temporary) {
            this.m_dvDevice.sendCommand("TSET BAUD " + baud);
        } else {
            this.m_dvDevice.sendCommand("SET BAUD " + baud);
        }
    }

    public void setCharDelay(int time) {
        if ((time = (time + 99) / 100) < 256) {
            this.m_dvDevice.sendCommand("CHARD-" + time);
        } else {
            if ((time /= 10) > 255) {
                time = 255;
            }
            this.m_dvDevice.sendCommand("CHARDM-" + time);
        }
    }

    public void set9BitMode(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("B9MON");
        } else {
            this.m_dvDevice.sendCommand("B9MOFF");
        }
    }

    public void setReceiveEnable(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("RXON");
        } else {
            this.m_dvDevice.sendCommand("RXOFF");
        }
    }

    public void setHardwareHandshake(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("HSON");
        } else {
            this.m_dvDevice.sendCommand("HSOFF");
        }
    }

    public void setSoftwareHandshake(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("XON");
        } else {
            this.m_dvDevice.sendCommand("XOFF");
        }
    }

    public void sendString(byte[] msg) {
        System.out.println("DeviceUtil.sendString 1");
        if (this.isIPControlEnabled()) {
            try {
                System.out.println("DeviceUtil.sendString 2");
                this.ipConnection.write(msg);
            }
            catch (Exception e) {
                if (this.m_mod != null) {
                    this.m_mod.log(4, "sendString: write failed " + new String(msg));
                }
            }
        } else {
            System.out.println("DeviceUtil.sendString 3");
            this.m_dvDevice.sendString(msg);
        }
    }

    private void error(String str) {
        Logger.error("DeviceUtil", str);
    }

    public ByteBuffer getData(ByteBuffer msg, String attributeCode) {
        if (msg.indexof("*" + attributeCode + "*") > 0 && (msg = msg.delete(msg.indexof("[[") + 2)).indexof("]") >= 0) {
            if ((msg = msg.delete(msg.indexof("]") + 1)).indexof("[") >= 0) {
                msg = msg.substring(3, msg.length() - 1);
            } else if (msg.indexof(34) >= 0) {
                msg = msg.substring(2);
            }
            return msg;
        }
        return null;
    }

    public class Property {
        public String key = "";
        public String value = "";
    }
}

