/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.protocol.newline.proseries.dr1_0_0;

import net.controlconcepts.duet.protocol.newline.proseries.dr1_0_0.NewlineCommandId;
import net.controlconcepts.duet.protocol.newline.proseries.dr1_0_0.NewlineSourceSelectId;

public class ProtocolUtil {
    private static byte[] makeRequest(NewlineCommandId id) {
        byte[] request = new byte[]{127, 8, -103, -94, -77, -60, 2, -1, 1, id.getValue(), -49};
        return request;
    }

    private static byte[] makeRequest(NewlineCommandId id, byte state) {
        byte[] request = new byte[]{127, 8, -103, -94, -77, -60, 2, -1, id.getValue(), state, -49};
        return request;
    }

    public static byte[] GetHeartbeat() {
        return ProtocolUtil.makeRequest(NewlineCommandId.HEARTBEAT);
    }

    public static byte[] GetPowerStatus() {
        return ProtocolUtil.makeRequest(NewlineCommandId.POWER_STATUS);
    }

    public static byte[] PowerOn() {
        return ProtocolUtil.makeRequest(NewlineCommandId.POWER_ON);
    }

    public static byte[] PowerOff() {
        return ProtocolUtil.makeRequest(NewlineCommandId.POWER_OFF);
    }

    public static byte[] GetSpeakerVolume() {
        return ProtocolUtil.makeRequest(NewlineCommandId.SPEAKER_VOLUME_STATUS);
    }

    public static byte[] SetSpeakerVolume(int level) {
        return ProtocolUtil.makeRequest(NewlineCommandId.SPEAKER_VOLUME_SET, (byte)level);
    }

    public static byte[] SetSpeakerVolumeUp() {
        return ProtocolUtil.makeRequest(NewlineCommandId.SPEAKER_VOLUME_UP);
    }

    public static byte[] SetSpeakerVolumeDown() {
        return ProtocolUtil.makeRequest(NewlineCommandId.SPEAKER_VOLUME_DOWN);
    }

    public static byte[] GetSpeakerMute() {
        return ProtocolUtil.makeRequest(NewlineCommandId.SPEAKER_MUTE_STATUS);
    }

    public static byte[] SetSpeakerMute(boolean mute) {
        byte bMute = 1;
        if (mute) {
            bMute = 0;
        }
        return ProtocolUtil.makeRequest(NewlineCommandId.AUDIO_MUTE_SET, bMute);
    }

    public static byte[] SetSpeakerMuteCycle() {
        return ProtocolUtil.makeRequest(NewlineCommandId.AUDIO_MUTE_CYCLE);
    }

    public static byte[] SetVideoFreeze(boolean mute) {
        byte bMute = 1;
        if (mute) {
            bMute = 0;
        }
        return ProtocolUtil.makeRequest(NewlineCommandId.VIDEO_FREEZE_SET, bMute);
    }

    public static byte[] SetVideoFreezeCycle() {
        return ProtocolUtil.makeRequest(NewlineCommandId.VIDEO_FREEZE_CYCLE);
    }

    public static byte[] GetSourceSelect() {
        return ProtocolUtil.makeRequest(NewlineCommandId.SOURCE_STATUS);
    }

    public static byte[] SetSourceSelect(NewlineSourceSelectId sourceId) {
        if (sourceId == null) {
            return null;
        }
        return ProtocolUtil.makeRequest(sourceId.getNewlineCommandId());
    }

    public static byte[] SetSignalSource() {
        return ProtocolUtil.makeRequest(NewlineCommandId.SIGNAL_SOURCE);
    }

    public static byte[] SetSdLocation() {
        String cmd = "logcat>/sdcard/logcat.log &";
        return cmd.getBytes();
    }

    public static byte[] SaveLogs() {
        String cmd = "ifconfig";
        return cmd.getBytes();
    }

    public static byte[] SetNavigationUp() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_UP);
    }

    public static byte[] SetNavigationDown() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_DOWN);
    }

    public static byte[] SetNavigationLeft() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_LEFT);
    }

    public static byte[] SetNavigationRight() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_RIGHT);
    }

    public static byte[] SetNavigationOk() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_OK);
    }

    public static byte[] SetNavigationMenu() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_MENU);
    }

    public static byte[] SetNavigationSettings() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_SETTINGS);
    }

    public static byte[] SetNavigationHome() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_HOME);
    }

    public static byte[] SetNavigationReturn() {
        return ProtocolUtil.makeRequest(NewlineCommandId.NAV_RETURN);
    }
}

