/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.impl.newline.proseries.dr1_0_0;

import com.amx.duet.core.master.netlinx.Event;
import com.amx.duet.core.master.netlinx.IDataListener;
import com.amx.duet.da.NetLinxDevice;
import com.amx.duet.devicesdk.Monitor;
import com.amx.duet.devicesdk.base.Module;
import com.amx.duet.devicesdk.component.ISourceSelectComponent;
import com.amx.duet.devicesdk.component.SourceSelectComponentEvent;
import com.amx.duet.devicesdk.type.Button;
import com.amx.duet.devicesdk.type.LevelRamp;
import com.amx.duet.devicesdk.type.Navigation;
import com.amx.duet.devicesdk.type.PowerState;
import com.amx.duet.devicesdk.utilities.PriorityQueue;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import net.controlconcepts.duet.common.newline.proseries.dr1_0_0.OutgoingMessage;
import net.controlconcepts.duet.framework.newline.proseries.dr1_0_0.IMainProcessListener;
import net.controlconcepts.duet.helpers.newline.proseries.dr1_0_0.RampTimerTask;
import net.controlconcepts.duet.helpers.newline.proseries.dr1_0_0.TimerPayload;
import net.controlconcepts.duet.helpers.newline.proseries.dr1_0_0.WakeOnLanUtil;
import net.controlconcepts.duet.impl.newline.proseries.dr1_0_0.DeviceUtil;
import net.controlconcepts.duet.interfaces.newline.proseries.dr1_0_0.ITimerListener;
import net.controlconcepts.duet.protocol.newline.proseries.dr1_0_0.NewlineCommandId;
import net.controlconcepts.duet.protocol.newline.proseries.dr1_0_0.NewlineSourceSelectId;
import net.controlconcepts.duet.protocol.newline.proseries.dr1_0_0.ProtocolUtil;
import net.controlconcepts.duet.tools.comm.newline.proseries.dr1_0_0.IDeviceListener;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ByteBuffer;
import net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0.HexUtil;
import net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0.NumericUtil;
import net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0.StringUtil;
import org.osgi.framework.BundleContext;

public class NewlineProSeries
extends Monitor
implements IMainProcessListener,
IDeviceListener,
IDataListener,
ITimerListener {
    private static final String DEFAULT_IP_ADDRESS = "192.168.1.100";
    private static final int DEFAULT_IP_PORT = 6688;
    private static final String[] VALID_RATES = new String[]{"19200"};
    private static final String COMM_PORT_STRING = ",N,8,1 485 DISABLE";
    private static final String DEFAULT_RATE = "19200";
    DeviceUtil utilities = null;
    private RampTimerTask rampTimerTask = null;
    private Timer rampTimer = null;
    protected PriorityQueue queue;
    protected ByteBuffer sbRxMsg;
    protected OutgoingMessage sbLastMsg;
    protected static final int PRIORITY_LEVELS = 2;
    protected static final int POLL_LEVEL = 1;
    protected static final int CMD_LEVEL = 2;
    private static final byte[] TERMINATOR = new byte[]{-49};
    boolean isResponseMessage = false;
    boolean isHeartbeat = false;
    boolean isInitialized = false;
    boolean initializeAttempted = false;
    boolean allowQuickPoll = true;
    private int nCurrentSource = 0;
    private boolean hasInitialized = false;
    private boolean poweringDown = false;

    public NewlineProSeries(BundleContext bctxt, NetLinxDevice nd, Properties props) {
        super(bctxt, nd, props);
        try {
            this.utilities = new DeviceUtil((Module)this, nd, props);
            this.utilities.setValidBaudRates(VALID_RATES);
            this.utilities.setDefaultBaudRate(NumericUtil.atoi(DEFAULT_RATE));
            this.utilities.setDefaultIPAddress(DEFAULT_IP_ADDRESS, 6688);
            this.queue = new PriorityQueue(2);
            this.sbRxMsg = new ByteBuffer();
            this.setProperty("IGNORE-UNKNOWN-NETLINX-COMMAND", "true");
        }
        catch (Exception e) {
            this.log(1, "NewlineProSeries Exception thrown in constructor: " + e.toString());
        }
        this.setDebugState(1);
    }

    public String getProperty(String key) {
        key = this.utilities.getPropertyKey(key);
        return super.getProperty(key);
    }

    public void setProperty(String key, String value) {
        DeviceUtil.Property prop = this.utilities.validateProperty(key, value);
        super.setProperty(prop.key, prop.value);
    }

    protected void doAddNetLinxDeviceListeners() {
        this.getNetLinxDevice().addDataListener((IDataListener)this);
    }

    protected boolean doNetLinxDeviceInitialization() {
        return !this.utilities.isIPControlEnabled();
    }

    public boolean isDeviceOnLine() {
        this.log(4, "NewlineProSeries isDeviceOnLine");
        return this.utilities.isDeviceOnLine();
    }

    public boolean isDataInitialized() {
        this.log(4, "NewlineProSeries isDataInitialized");
        return this.utilities.isDataInitialized();
    }

    @Override
    public void reinitialize() {
        try {
            this.log(4, "NewlineProSeries reinitialize");
            super.reinitialize();
            this.updatePowerState(PowerState.INVALID);
            this.updateInputSelect(0);
            this.updateVolume(0);
            this.updateVolumeMute(false);
            this.updateFreeze(false);
            this.utilities.reinitialize();
            this.utilities.setOnlineState(false);
            this.sbRxMsg.clear();
            this.queue.clearQue();
            this.utilities.intitializeConnection();
        }
        catch (Exception e) {
            this.log(1, "Exception thrown in reinitialize: " + e.toString());
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.utilities.refresh();
    }

    @Override
    public void setCommPort() {
        String sBaud = this.getProperty("Baud_Rate");
        this.utilities.setBaud(String.valueOf(sBaud) + COMM_PORT_STRING);
        this.utilities.setHardwareHandshake(false);
        this.utilities.setSoftwareHandshake(false);
    }

    public void enQueue(String msg) {
        OutgoingMessage out = new OutgoingMessage(this, new ByteBuffer(msg));
        this.enQueue(out, 2);
    }

    @Override
    public void enQueue(byte[] msg) {
        OutgoingMessage out = new OutgoingMessage(this, new ByteBuffer(msg));
        this.enQueue(out, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enQueue(OutgoingMessage out, int nPriorityLevel) {
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.utilities.restartQueueTimeline();
            this.queue.doEnq((Object)out, nPriorityLevel);
        }
    }

    @Override
    public void deQueue() {
        try {
            if (this.utilities.isQueueLocked() || this.queue.getQueSize() == 0) {
                return;
            }
            this.utilities.lockQueue(true);
            if (this.sbLastMsg != null) {
                this.log(4, "NewlineProSeries Failed Response, Force DeQueue");
                this.sbLastMsg = null;
            }
            this.sbLastMsg = (OutgoingMessage)this.queue.doDeq();
            if (this.sbLastMsg != null) {
                this.utilities.stopPolling();
                this.utilities.sendString(this.sbLastMsg.getMsg().toByteArray());
                this.utilities.startResponseTimer();
                if (this.utilities.isDataInitialized()) {
                    this.utilities.startPolling();
                }
                this.log(4, "NewlineProSeries Sent Message: " + StringUtil.toAsciiHexString(this.sbLastMsg.getMsg().toByteArray()));
            }
            if (this.queue.getQueSize() == 0) {
                this.utilities.pauseQueueTimeline();
            }
        }
        catch (Exception e) {
            if (this.getDebugState() == 4) {
                e.printStackTrace();
            }
            this.log(1, "NewlineProSeries Exception in deQueue: " + e.toString());
        }
    }

    @Override
    public void pollEvent() {
        this.queue.getQueSize(1);
    }

    @Override
    public void heartbeatEvent() {
        if (this.queue.getQueSize() == 0 && !this.poweringDown) {
            this.enQueue(ProtocolUtil.GetHeartbeat());
        }
    }

    @Override
    public void handleIncomingData(int bytesReceived, byte[] data) {
        if (data == null || data.length <= 0 || bytesReceived <= 0) {
            return;
        }
        this.sbRxMsg.append(new String(data, 0, bytesReceived));
        int location = -1;
        while ((location = this.sbRxMsg.indexof(TERMINATOR)) >= 0) {
            ByteBuffer msg = this.sbRxMsg.substring(0, location);
            this.log(4, "NewlineProSeries Msg Received: [" + StringUtil.toAsciiHexString(msg.toByteArray()) + "]");
            this.parseResponse(msg);
            this.sbRxMsg.delete(0, location + TERMINATOR.length);
        }
    }

    @Override
    public void handleOnlineEvent() {
        this.utilities.handleOnlineEvent();
    }

    @Override
    public void handleOfflineEvent() {
        this.utilities.handleOfflineEvent();
    }

    @Override
    public void handleErrorEvent(int error) {
        this.utilities.handleErrorEvent(error);
    }

    @Override
    public void responseTimeout() {
    }

    public void handleDataEvent(Event evt) {
        this.utilities.handleDataEvent(evt);
    }

    public void handleStringEvent(Event evt, String str) {
    }

    public void handleCommandEvent(Event obj, String cmd) {
        String upperCmd = cmd.toUpperCase();
        if (upperCmd.startsWith("?INPUTSELECT")) {
            ISourceSelectComponent comp = this.getSourceSelectComponent(1);
            comp.notify();
        }
    }

    public void handleChannelEvent(Event obj, String cmd) {
    }

    protected void parseResponse(ByteBuffer response) {
        block19: {
            try {
                try {
                    int commandIdPosition = -1;
                    OutgoingMessage last = this.sbLastMsg;
                    if (last == null || response.length() != 11) break block19;
                    commandIdPosition = last.getCommandIdPos();
                    byte lastCommandId = last.getMsg().byteAt(commandIdPosition);
                    byte responseCommandId = response.byteAt(commandIdPosition);
                    boolean bl = this.isResponseMessage = responseCommandId == lastCommandId;
                    if (!this.isResponseMessage) break block19;
                    byte value = response.byteAt(10);
                    if (NewlineCommandId.HEARTBEAT.equals(responseCommandId)) {
                        this.isHeartbeat = true;
                        this.updatePowerState(value == 1 ? PowerState.ON : PowerState.OFF);
                        this.quickPoll();
                        break block19;
                    }
                    if (NewlineCommandId.SPEAKER_MUTE_STATUS.equals(responseCommandId)) {
                        this.updateVolumeMute(value == 1);
                        break block19;
                    }
                    if (NewlineCommandId.SPEAKER_VOLUME_STATUS.equals(responseCommandId) || NewlineCommandId.SPEAKER_VOLUME_SET.equals(responseCommandId)) {
                        String sHexValue = StringUtil.toAsciiHexString(new byte[]{value});
                        int iValue = HexUtil.hextoi(sHexValue);
                        this.log(4, "NewlineProSeries.parseResponse: SPEAKER_VOLUME_STATUS " + iValue);
                        this.updateVolume(iValue);
                        break block19;
                    }
                    if (NewlineCommandId.SPEAKER_VOLUME_UP.equals(responseCommandId) || NewlineCommandId.SPEAKER_VOLUME_DOWN.equals(responseCommandId)) {
                        this.enQueue(ProtocolUtil.GetSpeakerVolume());
                        break block19;
                    }
                    if (NewlineCommandId.AUDIO_MUTE_CYCLE.equals(responseCommandId) || NewlineCommandId.AUDIO_MUTE_SET.equals(responseCommandId)) {
                        this.enQueue(ProtocolUtil.GetSpeakerMute());
                        this.enQueue(ProtocolUtil.GetSpeakerVolume());
                        break block19;
                    }
                    if (!NewlineCommandId.SOURCE_STATUS.equals(responseCommandId)) break block19;
                    NewlineSourceSelectId sourceId = NewlineSourceSelectId.getByValue(value);
                    if (sourceId != null) {
                        System.out.println("SOURCE STATUS Name: " + sourceId.getName());
                        if (sourceId != null) {
                            this.updateInputSelect(sourceId.getIndex());
                        }
                        break block19;
                    }
                    System.out.println("SOURCE STATUS NULL byte " + StringUtil.toAsciiHexString(new byte[]{value}));
                }
                catch (Exception e) {
                    if (this.getDebugState() == 4) {
                        e.printStackTrace();
                    }
                    this.log(1, "NewlineProSeries.parseResponse.Exception: " + e.getMessage());
                    if (this.isResponseMessage) {
                        this.sbLastMsg = null;
                        this.utilities.killResponseTimer();
                        this.utilities.setTimeoutCount(0);
                        this.utilities.lockQueue(false);
                        this.testInitialized();
                        if (this.isHeartbeat) {
                            this.log(4, "NewlineProSeries Heartbeat Received!!!");
                            this.utilities.setOnlineState(true);
                            if (!this.isInitialized()) {
                                this.getInitialized();
                            }
                        }
                        this.log(4, "NewlineProSeries Good Response!!!");
                    }
                }
            }
            finally {
                if (this.isResponseMessage) {
                    this.sbLastMsg = null;
                    this.utilities.killResponseTimer();
                    this.utilities.setTimeoutCount(0);
                    this.utilities.lockQueue(false);
                    this.testInitialized();
                    if (this.isHeartbeat) {
                        this.log(4, "NewlineProSeries Heartbeat Received!!!");
                        this.utilities.setOnlineState(true);
                        if (!this.isInitialized()) {
                            this.getInitialized();
                        }
                    }
                    this.log(4, "NewlineProSeries Good Response!!!");
                }
            }
        }
    }

    public void testInitialized() {
        if (!this.isDataInitialized() && this.isInitialized()) {
            this.utilities.setDataInitializedState(true);
            this.refresh();
            this.utilities.startPolling();
        }
    }

    @Override
    public void poll() {
    }

    public void quickPoll() {
        if (!this.poweringDown && this.getPower() == PowerState.ON) {
            this.enQueue(ProtocolUtil.GetSpeakerMute());
            this.enQueue(ProtocolUtil.GetSpeakerVolume());
            this.enQueue(ProtocolUtil.GetSourceSelect());
        }
    }

    @Override
    public void configure() {
    }

    @Override
    public void getInitialized() {
        if (!this.hasInitialized && this.utilities.isIPControlEnabled()) {
            WakeOnLanUtil.sendMagicPacket(DeviceUtil.getDeviceMacAddress(), 6688);
        }
        this.enQueue(ProtocolUtil.GetPowerStatus());
        if (this.getPower() == PowerState.ON) {
            this.enQueue(ProtocolUtil.GetSpeakerMute());
            this.enQueue(ProtocolUtil.GetSpeakerVolume());
            this.enQueue(ProtocolUtil.GetSourceSelect());
        }
        this.initializeAttempted = true;
    }

    @Override
    public boolean isInitialized() {
        PowerState power = this.getPower();
        if (this.initializeAttempted && power == PowerState.OFF) {
            this.hasInitialized = true;
            this.isInitialized = true;
        } else if (this.initializeAttempted && power == PowerState.ON) {
            if (this.getVolume() >= 0 && this.nCurrentSource > 0) {
                this.processInputSelectEvent(new SourceSelectComponentEvent((Object)this, this.nCurrentSource, 1));
                this.hasInitialized = true;
                this.isInitialized = true;
            } else {
                this.isInitialized = false;
            }
        } else {
            this.isInitialized = false;
        }
        this.log(4, "NewlineProSereis.IsInitialized: " + this.isInitialized);
        return this.isInitialized;
    }

    @Override
    public void processResponse(ByteBuffer responseMsg, ByteBuffer response) {
    }

    @Override
    public void processSubscription(ByteBuffer msg) {
    }

    public void startRampTimer(Object payload) {
        try {
            if (!(this.rampTimer instanceof Timer)) {
                this.rampTimer = new Timer();
                this.rampTimerTask = new RampTimerTask(this, payload);
                this.rampTimer.scheduleAtFixedRate((TimerTask)this.rampTimerTask, 1000L, 1000L);
            }
        }
        catch (Exception ex) {
            this.log(1, "NewlineProSeries.startRampTimer.exception: " + ex.getMessage());
        }
    }

    public void stopRampTimer() {
        try {
            if (this.rampTimer instanceof Timer) {
                this.rampTimerTask.cancel();
                this.rampTimer.cancel();
                this.rampTimerTask = null;
                this.rampTimer = null;
            }
        }
        catch (Exception ex) {
            this.log(1, "NewlineProSeries.stopRampTimer.exception: " + ex.getMessage());
        }
    }

    @Override
    public void handleTimerEvent(Object state) {
        try {
            if (state instanceof TimerPayload) {
                TimerPayload payload = (TimerPayload)state;
                if (payload.timerID.equals("RAMP")) {
                    if (payload.state == LevelRamp.UP) {
                        this.enQueue(ProtocolUtil.SetSpeakerVolumeUp());
                    } else if (payload.state == LevelRamp.DOWN) {
                        this.enQueue(ProtocolUtil.SetSpeakerVolumeDown());
                    }
                }
            }
        }
        catch (Exception ex) {
            this.log(1, "NewlineProSeries.handleTimerEvent.exception: " + ex.getMessage());
        }
    }

    public void setPowerInternal(PowerState ps) {
        if (!this.isInitialized) {
            return;
        }
        if (ps.equals((Object)PowerState.ON)) {
            this.poweringDown = false;
            if (this.utilities.isIPControlEnabled()) {
                WakeOnLanUtil.sendMagicPacket(DeviceUtil.getDeviceMacAddress(), 6688);
                this.utilities.ipConnect();
            } else {
                this.enQueue(ProtocolUtil.PowerOn());
            }
        } else if (ps.equals((Object)PowerState.OFF)) {
            this.poweringDown = true;
            this.enQueue(ProtocolUtil.PowerOff());
            this.enQueue(ProtocolUtil.PowerOff());
            this.updatePowerState(PowerState.OFF);
        }
    }

    public void cyclePowerInternal() {
        if (!this.isInitialized) {
            return;
        }
        PowerState ps = this.getPower();
        if (ps.equals((Object)PowerState.ON)) {
            this.poweringDown = true;
            this.enQueue(ProtocolUtil.PowerOff());
            this.enQueue(ProtocolUtil.PowerOff());
            this.updatePowerState(PowerState.OFF);
        } else if (ps.equals((Object)PowerState.OFF)) {
            this.poweringDown = false;
            if (this.utilities.isIPControlEnabled()) {
                WakeOnLanUtil.sendMagicPacket(DeviceUtil.getDeviceMacAddress(), 6688);
                this.utilities.ipConnect();
            } else {
                this.enQueue(ProtocolUtil.PowerOn());
            }
        }
    }

    public void setVolume(int level) {
        if (!this.isInitialized) {
            return;
        }
        this.enQueue(ProtocolUtil.SetSpeakerVolume(level));
    }

    public void setVolumeRamp(LevelRamp rl) {
        if (!this.isInitialized) {
            return;
        }
        if (rl == LevelRamp.UP) {
            this.enQueue(ProtocolUtil.SetSpeakerVolumeUp());
            this.startRampTimer(new TimerPayload("RAMP", rl));
        } else if (rl == LevelRamp.DOWN) {
            this.enQueue(ProtocolUtil.SetSpeakerVolumeDown());
            this.startRampTimer(new TimerPayload("RAMP", rl));
        } else if (rl == LevelRamp.STOP) {
            this.stopRampTimer();
        }
    }

    public void setVolumeMuteOn(boolean state) {
        if (this.isInitialized) {
            this.enQueue(ProtocolUtil.SetSpeakerMute(state));
            this.enQueue(ProtocolUtil.GetSpeakerVolume());
        }
    }

    public void cycleVolumeMute() {
        if (this.isInitialized) {
            this.enQueue(ProtocolUtil.SetSpeakerMuteCycle());
        }
    }

    public void setFreezeOn(boolean state) {
        if (this.isInitialized) {
            this.enQueue(ProtocolUtil.SetVideoFreeze(state));
        }
    }

    public void cycleFreeze() {
        if (this.isInitialized) {
            this.enQueue(ProtocolUtil.SetVideoFreezeCycle());
        }
    }

    public int getInputCount() {
        return 9;
    }

    public String[] getInputProperties() {
        String[] inputList = new String[]{NewlineSourceSelectId.HDMI1.getName(), NewlineSourceSelectId.HDMI2.getName(), NewlineSourceSelectId.HDMI3.getName(), NewlineSourceSelectId.USBC1.getName(), NewlineSourceSelectId.USBC2.getName(), NewlineSourceSelectId.PC.getName(), NewlineSourceSelectId.SDM.getName(), NewlineSourceSelectId.DP.getName(), NewlineSourceSelectId.SS.getName()};
        return inputList;
    }

    public void setInputSelect(int index) {
        if (!this.isInitialized) {
            return;
        }
        this.enQueue(ProtocolUtil.SetSourceSelect(NewlineSourceSelectId.getByIndex(index)));
        this.enQueue(ProtocolUtil.GetSourceSelect());
    }

    public void cycleInputSource() {
        if (!this.isInitialized) {
            return;
        }
        this.enQueue(ProtocolUtil.SetSignalSource());
        this.enQueue(ProtocolUtil.GetSourceSelect());
    }

    protected void updateInputSelect(int index) {
        if (this.nCurrentSource != index) {
            this.nCurrentSource = index;
            this.processInputSelectEvent(new SourceSelectComponentEvent((Object)this, this.nCurrentSource, 1));
        }
    }

    public void pressMenuButton(Button button) {
        if (!this.isInitialized) {
            return;
        }
        if (button == Button.ENTER) {
            this.enQueue(ProtocolUtil.SetNavigationOk());
        } else if (button == Button.RETURN) {
            this.enQueue(ProtocolUtil.SetNavigationReturn());
        } else if (button == Button.EXIT) {
            this.enQueue(ProtocolUtil.SetNavigationHome());
        } else if (button.toString() == "INFO") {
            this.enQueue(ProtocolUtil.SetNavigationSettings());
        } else if (button.toString() == "MENU") {
            this.enQueue(ProtocolUtil.SetNavigationMenu());
        }
    }

    public void moveMenuCursor(Navigation direction) {
        if (!this.isInitialized) {
            return;
        }
        if (direction == Navigation.UP) {
            this.enQueue(ProtocolUtil.SetNavigationUp());
        } else if (direction == Navigation.DOWN) {
            this.enQueue(ProtocolUtil.SetNavigationDown());
        } else if (direction == Navigation.LEFT) {
            this.enQueue(ProtocolUtil.SetNavigationLeft());
        } else if (direction == Navigation.RIGHT) {
            this.enQueue(ProtocolUtil.SetNavigationRight());
        }
    }

    public void selectMenuItem() {
        if (this.isInitialized) {
            this.enQueue(ProtocolUtil.SetNavigationOk());
        }
    }
}

