/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.impl.newline.proseries.dr1_0_0;

import com.amx.duet.core.master.netlinx.DPS;
import com.amx.duet.core.master.netlinx.Event;
import com.amx.duet.core.master.netlinx.Level;
import com.amx.duet.core.util.FormatUtil;
import com.amx.duet.core.util.NetLinxSystemUtil;
import com.amx.duet.da.NetLinxDevice;
import com.amx.duet.da.SerialDevice;
import com.amx.duet.devicesdk.base.AdvancedEvent;
import com.amx.duet.devicesdk.base.Module;
import com.amx.duet.devicesdk.base.ModuleComponentEvent;
import com.amx.duet.devicesdk.base.TypeSafeEnumBase;
import com.amx.duet.devicesdk.component.IPreAmpComponent;
import com.amx.duet.devicesdk.type.SurroundMode;
import com.amx.duet.util.Timeline;
import com.amx.duet.util.TimelineListener;
import com.amx.duet.util.Timer;
import com.amx.duet.util.TimerListener;
import java.io.File;
import java.util.List;
import java.util.Properties;
import net.controlconcepts.duet.helpers.newline.proseries.dr1_0_0.WakeOnLanUtil;
import net.controlconcepts.duet.tools.comm.newline.proseries.dr1_0_0.IDeviceListener;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.Logger;
import net.controlconcepts.duet.tools.lang.newline.proseries.dr1_0_0.ValidateUtil;
import net.controlconcepts.duet.tools.net.tcp.newline.proseries.dr1_0_0.SocketConnection;
import net.controlconcepts.duet.tools.net.tcp.newline.proseries.dr1_0_0.SocketConnectionListener;
import net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0.NumericUtil;

public class DeviceUtil
implements TimelineListener,
TimerListener,
SocketConnectionListener {
    public static final int POLL_TIME_MIN = 1000;
    public static final int POLL_TIME_MAX = 300000;
    public static final int RECONNECT_TIME_MIN = 1000;
    public static final int RECONNECT_TIME_MAX = 60000;
    public static final int DEFAULT_POLL_TIME = 60000;
    public static final int DEFAULT_CONNECT_TIME = 30000;
    public static final int DEFAULT_QUEUE_TIME = 200;
    public static final int DEFAULT_HEART_TIME = 15000;
    public static final int DEFAULT_TIMEOUT_COUNT = 3;
    public static final long TIME_OUT = 10000L;
    public static final String BAUD_RATE = "Baud_Rate";
    public static final String PASSWORD = "Password";
    public static final String USERNAME = "User_Name";
    public static final String POLL_TIME = "Poll_Time";
    public static final String DEVICE_ID = "Device_ID";
    public static final String IP_PORT = "Port";
    public static final String IP_ADDRESS = "IP_Address";
    public static final String MAC_ADDRESS = "MAC_Address";
    public static final String TIMEOUT_COUNT = "Timeout_Count";
    public static final String RECONNECT_TIME = "Reconnect_Time";
    public static final String SYSTEM_DIAGNOSTIC = "System_Diagnostic";
    public static final int IP_ONLY = 1;
    public static final int IP_SERIAL = 2;
    public static final int SERIAL_ONLY = 3;
    public static final int MIN_LVL = 0;
    public static final int MAX_LVL = 255;
    public static final int MIN_ADJUST = -255;
    public static final int MAX_ADJUST = 255;
    public static final int DEBUG = 4;
    public static final int INFO = 4;
    public static final int WARNING = 4;
    public static final int ERROR = 4;
    private Module m_mod = null;
    private boolean m_bOnline = false;
    private boolean m_bInitialized = false;
    private NetLinxDevice m_dvDevice = null;
    private SocketConnection ipConnection = null;
    private boolean m_bIPControlled = false;
    private boolean m_bConnecting = false;
    private long[] lReConnect = new long[]{30000L};
    private Timeline tReConnectTimeline = null;
    private long[] lDeQueTime = new long[]{200L};
    private Timeline tDeQueTimeline = null;
    private long[] lPollTime = new long[]{60000L};
    private Timeline tPollTimeline = null;
    private long[] lHeartBeatTime = new long[]{15000L};
    private Timeline tHeartBeatTimeline = null;
    private Timer tResponseTimer = null;
    private int nMAX_TIMEOUT = 3;
    private int m_nTimeoutCount = 0;
    private boolean m_bSystemDiag = false;
    private boolean bQueueTimePaused = false;
    private boolean bQueueLock = false;
    private Object sync = new Object();
    private String[] m_rates = null;
    private int m_baud = 9600;
    private String m_ipAddress = "255.255.255.255";
    private static String deviceIpAddress = "";
    private static String deviceMacAddress = "";
    Properties m_props = null;
    private boolean bDisposing = false;
    private boolean bPolling = false;
    private boolean bHeartbeating = false;
    private boolean bQueueing = false;
    private boolean initialConnection = false;
    private boolean blockFalseState = false;

    public DeviceUtil() {
    }

    public DeviceUtil(Module mod) {
        this.setCommonDevice(mod);
    }

    public DeviceUtil(Module mod, NetLinxDevice nd, Properties props) {
        this.setCommonDevice(mod);
        this.m_props = props;
        this.initialize(nd);
    }

    protected void initialize(NetLinxDevice nd) {
        block11: {
            if (this.m_mod == null) {
                this.error("Common device not found");
                return;
            }
            this.log(4, "DeviceUtil.initialize(nd) called");
            try {
                int nDeviceType = this.isIPControlled();
                if (nDeviceType == 1) {
                    this.enableIPControl(true);
                    this.initialConnection = false;
                } else if (nDeviceType == 2) {
                    if (nd != null && ValidateUtil.isValidDPS(nd.getDPS())) {
                        this.setNetLinxDevice(nd);
                    } else {
                        this.enableIPControl(true);
                    }
                } else if (nDeviceType == 3) {
                    this.setNetLinxDevice(nd);
                }
                this.tHeartBeatTimeline = new Timeline((TimelineListener)this, this.lHeartBeatTime, true, -1);
                this.tDeQueTimeline = new Timeline((TimelineListener)this, this.lDeQueTime, true, -1);
                this.tPollTimeline = new Timeline((TimelineListener)this, this.lPollTime, true, -1);
                if (this.isIPControlEnabled()) {
                    this.setProperty(RECONNECT_TIME, NumericUtil.ltoa(30000L));
                    this.tReConnectTimeline = new Timeline((TimelineListener)this, this.lReConnect, true, -1);
                    this.tReConnectTimeline.start();
                }
                this.setProperty(POLL_TIME, NumericUtil.ltoa(60000L));
                this.setProperty(TIMEOUT_COUNT, NumericUtil.itoa(3));
            }
            catch (Exception e) {
                this.error("Exception in DeviceUtil initialize() - " + e.toString());
                if (this.m_mod.getDebugState() != 4) break block11;
                e.printStackTrace();
            }
        }
    }

    public void setCommonDevice(Module mod) {
        this.m_mod = mod;
    }

    public Module getCommonDevice() {
        return this.m_mod;
    }

    public boolean isDeviceOnLine() {
        return this.m_bOnline;
    }

    public boolean isDataInitialized() {
        return this.m_bInitialized;
    }

    public void setNetLinxDevice(NetLinxDevice nd) {
        this.m_dvDevice = nd;
    }

    public NetLinxDevice getNetLinxDevice() {
        return this.m_dvDevice;
    }

    public void setMaxTimeout(int count) {
        this.nMAX_TIMEOUT = count;
    }

    public int getMaxTimeout() {
        return this.nMAX_TIMEOUT;
    }

    public void setTimeoutCount(int count) {
        this.m_nTimeoutCount = count;
    }

    public void incrementTimeout() {
        ++this.m_nTimeoutCount;
    }

    public int getTimeoutCount() {
        return this.m_nTimeoutCount;
    }

    public void setValidBaudRates(String[] rates) {
        this.m_rates = rates;
    }

    public String[] getValidBaudRates() {
        return this.m_rates;
    }

    public void setDefaultBaudRate(int rate) {
        this.m_baud = rate;
        this.setProperty(BAUD_RATE, NumericUtil.itoa(this.m_baud));
    }

    public void setDefaultIPAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
        this.setProperty(IP_ADDRESS, ipAddress);
    }

    public void setDefaultIPAddress(String ipAddress, int port) {
        this.setDefaultIPAddress(ipAddress);
        this.setProperty(IP_PORT, NumericUtil.itoa(port));
    }

    public boolean isIPControlEnabled() {
        return this.m_bIPControlled;
    }

    protected void enableIPControl(boolean enable) {
        this.m_bIPControlled = enable;
    }

    public boolean isDisposing() {
        return this.bDisposing;
    }

    public boolean isPolling() {
        return this.bPolling;
    }

    public boolean isHeartbeating() {
        return this.bHeartbeating;
    }

    public boolean isQueing() {
        return this.bQueueing;
    }

    private String getProperty(String key) {
        block3: {
            try {
                if (this.m_mod != null) {
                    String value = this.m_mod.getProperty(key);
                    this.log(4, "getProperty(" + key + ") = " + value);
                    return value;
                }
            }
            catch (Exception e) {
                if (this.m_props == null) break block3;
                String value = this.m_props.getProperty(key);
                this.log(4, "getProperty(" + key + ") = " + value);
                return value;
            }
        }
        return null;
    }

    private void setProperty(String key, String value) {
        block3: {
            try {
                if (this.m_mod != null) {
                    this.m_mod.setProperty(key, value);
                    this.log(4, "setProperty(" + key + "," + value + ")");
                }
            }
            catch (Exception e) {
                if (this.m_props == null) break block3;
                this.m_props.setProperty(key, value);
                this.log(4, "setProperty(" + key + "," + value + ")");
            }
        }
    }

    public String getPropertyKey(String key) {
        if (key.compareToIgnoreCase(BAUD_RATE) == 0) {
            key = BAUD_RATE;
        } else if (key.compareToIgnoreCase(IP_ADDRESS) == 0) {
            key = IP_ADDRESS;
        } else if (key.compareToIgnoreCase("IP-Address") == 0) {
            key = IP_ADDRESS;
        } else if (key.compareToIgnoreCase(MAC_ADDRESS) == 0) {
            key = MAC_ADDRESS;
        } else if (key.compareToIgnoreCase(IP_PORT) == 0) {
            key = IP_PORT;
        } else if (key.compareToIgnoreCase(POLL_TIME) == 0) {
            key = POLL_TIME;
        } else if (key.compareToIgnoreCase(DEVICE_ID) == 0) {
            key = DEVICE_ID;
        } else if (key.compareToIgnoreCase(TIMEOUT_COUNT) == 0) {
            key = TIMEOUT_COUNT;
        } else if (key.compareToIgnoreCase(RECONNECT_TIME) == 0) {
            key = RECONNECT_TIME;
        } else if (key.compareToIgnoreCase(PASSWORD) == 0) {
            key = PASSWORD;
        } else if (key.compareToIgnoreCase(USERNAME) == 0) {
            key = USERNAME;
        }
        return key;
    }

    public Property validateProperty(String key, String value) {
        Property prop = new Property();
        if (key.compareToIgnoreCase(BAUD_RATE) == 0) {
            prop.value = ValidateUtil.validateBaudRate(value, this.getValidBaudRates(), NumericUtil.itoa(this.m_baud));
            prop.key = BAUD_RATE;
        } else if (key.compareToIgnoreCase(USERNAME) == 0) {
            prop.value = value;
            prop.key = USERNAME;
        } else if (key.compareToIgnoreCase(PASSWORD) == 0) {
            prop.value = value;
            prop.key = PASSWORD;
        } else if (key.compareToIgnoreCase(IP_ADDRESS) == 0) {
            prop.value = value;
            if (!ValidateUtil.isValidIP(value)) {
                prop.value = this.m_ipAddress;
            }
            deviceIpAddress = prop.value;
            prop.key = IP_ADDRESS;
        } else if (key.compareToIgnoreCase("IP-Address") == 0) {
            prop.value = value;
            if (!ValidateUtil.isValidIP(value)) {
                prop.value = this.m_ipAddress;
            }
            deviceIpAddress = prop.value;
            prop.key = IP_ADDRESS;
        } else if (key.compareToIgnoreCase(MAC_ADDRESS) == 0) {
            deviceMacAddress = prop.value = value;
            prop.key = MAC_ADDRESS;
        } else if (key.compareToIgnoreCase(IP_PORT) == 0) {
            prop.value = value;
            prop.key = IP_PORT;
        }
        if (key.compareToIgnoreCase(POLL_TIME) == 0) {
            prop.value = ValidateUtil.validatePollTime(value, 1000L, 300000L, 60000L);
            prop.key = POLL_TIME;
        } else if (key.compareToIgnoreCase(DEVICE_ID) == 0) {
            prop.value = ValidateUtil.validateDeviceID(value, 0, 255, "00");
            prop.key = DEVICE_ID;
        } else if (key.compareToIgnoreCase(TIMEOUT_COUNT) == 0) {
            prop.value = ValidateUtil.validateTimeoutCount(value, this.getMaxTimeout(), 3);
            prop.key = TIMEOUT_COUNT;
        } else if (key.compareToIgnoreCase(RECONNECT_TIME) == 0) {
            prop.value = ValidateUtil.validateReconnnectTime(value, 1000L, 60000L, 30000L);
            prop.key = RECONNECT_TIME;
        } else if (key.compareToIgnoreCase(SYSTEM_DIAGNOSTIC) == 0) {
            if (NumericUtil.atoi(value) == 1) {
                this.m_bSystemDiag = true;
                this.m_bOnline = this.setOnlineState(true);
                this.m_bInitialized = this.setDataInitializedState(true);
            } else {
                this.m_bSystemDiag = false;
                this.m_bInitialized = this.setDataInitializedState(false);
            }
            prop.value = value;
            prop.key = SYSTEM_DIAGNOSTIC;
        } else {
            prop.value = value;
            prop.key = key;
        }
        return prop;
    }

    public boolean isInDiagnosticMode() {
        return this.m_bSystemDiag;
    }

    public void refresh() {
        if (this.m_mod != null) {
            this.log(4, "DeviceUtil.refresh() called");
            this.m_mod.processDeviceOnLineEvent(new ModuleComponentEvent((Object)this.m_mod, this.isDeviceOnLine(), 1));
            this.m_mod.processDataInitializedEvent(new ModuleComponentEvent((Object)this.m_mod, this.isDataInitialized(), 1));
        }
    }

    public void reinitialize() {
        this.log(4, "DeviceUtil.reinitialize() called");
        this.killResponseTimer();
        this.killHeartbeatTimeline();
        this.killQueueTimeline();
        this.stopPolling();
        if (this.isIPControlEnabled() && this.tReConnectTimeline != null) {
            this.tReConnectTimeline.kill();
        }
        this.setMaxTimeout(NumericUtil.atoi(this.getProperty(TIMEOUT_COUNT)));
        if (this.isIPControlEnabled() && this.isConnected()) {
            this.initialConnection = false;
            this.ipClose();
        }
        if (this.isDataInitialized()) {
            this.m_bInitialized = this.setDataInitializedState(false);
        }
        this.lockQueue(false);
        this.bQueueTimePaused = false;
    }

    public void dispose() {
        block18: {
            this.log(4, "DeviceUtil.dispose() called");
            this.bDisposing = true;
            try {
                try {
                    if (this.isIPControlEnabled() && this.ipConnection != null) {
                        this.ipClose();
                        this.ipConnection.dispose();
                        this.ipConnection = null;
                    }
                }
                catch (Exception e) {
                    System.out.println("Exception in dispose()" + e.toString());
                    e.printStackTrace();
                    this.killResponseTimer();
                    if (this.tHeartBeatTimeline != null) {
                        this.tHeartBeatTimeline.kill();
                        this.tHeartBeatTimeline = null;
                    }
                    if (this.tDeQueTimeline != null) {
                        this.tDeQueTimeline.kill();
                        this.tDeQueTimeline = null;
                    }
                    if (this.tPollTimeline != null) {
                        this.tPollTimeline.kill();
                        this.tPollTimeline = null;
                    }
                    if (this.isIPControlEnabled() && this.tReConnectTimeline != null) {
                        this.tReConnectTimeline.kill();
                        this.tReConnectTimeline = null;
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                this.killResponseTimer();
                if (this.tHeartBeatTimeline != null) {
                    this.tHeartBeatTimeline.kill();
                    this.tHeartBeatTimeline = null;
                }
                if (this.tDeQueTimeline != null) {
                    this.tDeQueTimeline.kill();
                    this.tDeQueTimeline = null;
                }
                if (this.tPollTimeline != null) {
                    this.tPollTimeline.kill();
                    this.tPollTimeline = null;
                }
                if (this.isIPControlEnabled() && this.tReConnectTimeline != null) {
                    this.tReConnectTimeline.kill();
                    this.tReConnectTimeline = null;
                }
                throw throwable;
            }
            this.killResponseTimer();
            if (this.tHeartBeatTimeline != null) {
                this.tHeartBeatTimeline.kill();
                this.tHeartBeatTimeline = null;
            }
            if (this.tDeQueTimeline != null) {
                this.tDeQueTimeline.kill();
                this.tDeQueTimeline = null;
            }
            if (this.tPollTimeline != null) {
                this.tPollTimeline.kill();
                this.tPollTimeline = null;
            }
            if (this.isIPControlEnabled() && this.tReConnectTimeline != null) {
                this.tReConnectTimeline.kill();
                this.tReConnectTimeline = null;
            }
        }
        this.bPolling = false;
        this.bHeartbeating = false;
        this.bQueueing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockQueue(boolean bLock) {
        this.log(4, "lockQueue(" + bLock + ")");
        Object object = this.sync;
        synchronized (object) {
            this.bQueueLock = bLock;
        }
    }

    public boolean isQueueLocked() {
        return this.bQueueLock;
    }

    public boolean ipConnect() {
        this.initialConnection = false;
        if (this.bDisposing) {
            return false;
        }
        if (this.m_mod == null) {
            this.error("Common device not found");
            return false;
        }
        if (this.isConnected() || this.m_bConnecting) {
            return false;
        }
        this.log(4, "connecting socket...");
        this.m_bConnecting = true;
        String ipAddress = this.getProperty(IP_ADDRESS);
        int nPort = NumericUtil.atoi(this.getProperty(IP_PORT));
        WakeOnLanUtil.sendMagicPacket(DeviceUtil.getDeviceMacAddress(), nPort);
        if (ipAddress != null && ipAddress.length() > 0 && nPort > 0) {
            this.log(4, "connecting to " + ipAddress + ":" + nPort);
            if (this.ipConnection == null) {
                this.ipConnection = new SocketConnection(ipAddress, nPort, 1024, (SocketConnectionListener)this);
            } else {
                this.ipConnection.setAddressAndPort(ipAddress, nPort);
            }
            return this.ipConnection.connect();
        }
        this.m_bConnecting = false;
        if (this.m_mod instanceof IDeviceListener) {
            ((IDeviceListener)this.m_mod).handleErrorEvent(-3);
        }
        return false;
    }

    public void ipClose() {
        this.log(4, "closing socket...");
        if (this.isConnected()) {
            this.ipConnection.disconnect();
        }
    }

    public boolean isConnected() {
        boolean connected = false;
        if (this.ipConnection != null) {
            connected = this.ipConnection.isConnected();
        }
        return connected;
    }

    public void reconnect() {
        if (this.initialConnection) {
            return;
        }
        if (this.bDisposing) {
            return;
        }
        this.log(4, "DeviceUtil.reconnect() called");
        if (this.isIPControlEnabled()) {
            this.lReConnect[0] = NumericUtil.atol(this.getProperty(RECONNECT_TIME));
            this.tReConnectTimeline.reload(this.lReConnect);
            this.tReConnectTimeline.start();
        }
    }

    public void intitializeConnection() {
        if (!this.isIPControlEnabled()) {
            if (this.m_mod != null && this.m_mod instanceof IDeviceListener) {
                ((IDeviceListener)this.m_mod).handleOnlineEvent();
            }
        } else if (!this.initialConnection) {
            this.reconnect();
        }
    }

    public void handleAdvancedEvent(Event advancedEvent) {
        block8: {
            this.log(4, "handleAdvancedEvent(" + advancedEvent + ")");
            if (this.m_mod == null) {
                this.error("Common device not found");
                return;
            }
            try {
                if (this.m_mod instanceof IDeviceListener) {
                    switch (advancedEvent.type) {
                        case 64: {
                            if (advancedEvent.dataType == 9) {
                                DPS dps = advancedEvent.dps;
                                int zone = dps.getPort();
                                String commandMessage = new String((byte[])advancedEvent.dataValue);
                                this.log(4, "Comm received from UI: " + commandMessage);
                                this.handleSurroundCommand(commandMessage, zone);
                                break;
                            }
                        }
                        default: {
                            this.log(4, "UNHANDLED ADVANCED EVENT: event.type: " + advancedEvent.type);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log(4, "Exception in handleAdvancedEvent: " + e.getLocalizedMessage());
                if (this.m_mod.getDebugState() != 4) break block8;
                e.printStackTrace();
            }
        }
    }

    private void handleSurroundCommand(String commandString, int zone) {
        String command = "";
        int nIndex = commandString.indexOf("-");
        if (nIndex == -1) {
            nIndex = commandString.length() - 1;
        }
        command = commandString.substring(0, nIndex + 1).trim().toUpperCase();
        commandString = commandString.substring(nIndex + 1).trim();
        if (command.startsWith("SURROUND-") && this.m_mod instanceof IPreAmpComponent) {
            IPreAmpComponent preAmp = (IPreAmpComponent)this.m_mod;
            preAmp = preAmp.getPreAmpComponent(zone);
            this.log(4, "Handling: " + command);
            this.log(4, "commandString: " + commandString);
            if (commandString.length() > 0) {
                TypeSafeEnumBase surroundModeResult = TypeSafeEnumBase.fromString((String)commandString, (List)preAmp.getSurroundModeValues());
                if (surroundModeResult instanceof SurroundMode) {
                    preAmp.setSurroundMode((SurroundMode)surroundModeResult);
                } else {
                    this.log(4, "Warning: " + commandString + " is not a valid SurroundMode.");
                }
            } else {
                this.log(4, "Warning: SURROUND- command missing parameter");
            }
        }
    }

    public void handleDataEvent(Event evt) {
        block11: {
            if (this.m_mod == null) {
                this.error("Common device not found");
                return;
            }
            try {
                NetLinxDevice dvDevice = this.getNetLinxDevice();
                if (!evt.getDPS().equals((Object)dvDevice.getDPS())) {
                    this.log(4, "Invalid event - device = " + evt.dps);
                    return;
                }
                if (this.m_mod instanceof IDeviceListener) {
                    switch (evt.type) {
                        case 512: {
                            this.initialConnection = true;
                            this.blockFalseState = true;
                            ((IDeviceListener)this.m_mod).handleOnlineEvent();
                            break;
                        }
                        case 1024: {
                            ((IDeviceListener)this.m_mod).handleOfflineEvent();
                            break;
                        }
                        case 128: {
                            ((IDeviceListener)this.m_mod).handleErrorEvent(0);
                            break;
                        }
                        case 32: {
                            byte[] data = (byte[])evt.dataValue;
                            this.handleReceive(data.length, data);
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log(4, "Exception in handleDataEvent: " + e.getLocalizedMessage());
                if (this.m_mod.getDebugState() != 4) break block11;
                e.printStackTrace();
            }
        }
    }

    public void handleOnlineEvent() {
        if (this.bDisposing) {
            return;
        }
        this.log(4, "DeviceUtil.handleOnlineEvent() called");
        if (!this.isIPControlEnabled()) {
            if (this.m_dvDevice == null) {
                this.error("NetLinxDevice not found");
                return;
            }
            if (this.m_mod instanceof IDeviceListener) {
                ((IDeviceListener)this.m_mod).setCommPort();
            }
        }
        if (this.isIPControlEnabled()) {
            this.initialConnection = true;
            this.blockFalseState = true;
            if (this.tReConnectTimeline != null) {
                this.tReConnectTimeline.kill();
            }
            this.m_bConnecting = false;
        }
        this.startQueueTimeline();
        this.startHeartbeatTimeline();
        ((IDeviceListener)this.m_mod).heartbeatEvent();
    }

    public void handleOfflineEvent() {
        if (!this.initialConnection) {
            this.log(4, "DeviceUtil.handleOfflineEvent() called");
            if (this.isDeviceOnLine()) {
                this.incrementTimeout();
                if (this.getTimeoutCount() >= this.getMaxTimeout()) {
                    this.log(4, "Setting device offline.");
                    this.setOnlineState(false);
                    this.setTimeoutCount(0);
                }
            }
            if (this.isDataInitialized()) {
                this.setDataInitializedState(false);
            }
            if (this.isIPControlEnabled()) {
                this.log(4, "Socket closed by peer");
                this.m_bConnecting = false;
            }
            if (this.m_mod != null) {
                this.m_mod.reinitialize();
            }
        }
    }

    public void handleErrorEvent(int error) {
        this.log(4, "DeviceUtil.handleErrorEvent(" + error + ")");
        switch (error) {
            case -1: {
                this.log(4, "handleErrorEvent: socket timed out");
                break;
            }
            case -4: {
                this.log(4, "handleErrorEvent: socket failed to connect");
                break;
            }
            default: {
                this.log(4, "handleErrorEvent: unknown error - status [" + error + "]");
            }
        }
        if (!this.initialConnection) {
            if (this.isIPControlEnabled() && this.isConnected()) {
                this.ipClose();
            } else if (this.m_mod instanceof IDeviceListener) {
                ((IDeviceListener)this.m_mod).handleOfflineEvent();
            }
        }
    }

    public void handleTimelineEvent(Timeline timeline) {
        if (this.m_mod instanceof IDeviceListener) {
            if (timeline == this.tDeQueTimeline) {
                ((IDeviceListener)this.m_mod).deQueue();
            } else if (timeline == this.tPollTimeline) {
                ((IDeviceListener)this.m_mod).pollEvent();
            } else if (timeline == this.tHeartBeatTimeline) {
                ((IDeviceListener)this.m_mod).heartbeatEvent();
            }
        }
        if (timeline == this.tReConnectTimeline) {
            if (this.isConnected() || this.m_bConnecting) {
                return;
            }
            this.ipConnect();
        } else if (this.m_mod instanceof TimelineListener) {
            ((TimelineListener)this.m_mod).handleTimelineEvent(timeline);
        }
    }

    public void handleTimerEvent(Timer timer) {
        if (timer == this.tResponseTimer) {
            this.log(4, "Response timer timed out.");
            this.tResponseTimer.cancel();
            this.tResponseTimer = null;
            this.lockQueue(false);
            if (this.isDeviceOnLine()) {
                this.incrementTimeout();
                if (this.getTimeoutCount() >= this.getMaxTimeout()) {
                    this.setTimeoutCount(0);
                    if (this.m_mod != null) {
                        this.m_mod.reinitialize();
                    }
                }
            }
        }
    }

    @Override
    public void handleReceive(int bytesReceived, byte[] data) {
        if (this.m_mod != null) {
            this.m_mod.processPassBackEvent(new ModuleComponentEvent((Object)this.m_mod, (Object)new String(data, 0, bytesReceived), 1));
        }
        if (this.m_mod instanceof IDeviceListener) {
            ((IDeviceListener)this.m_mod).handleIncomingData(bytesReceived, data);
        } else if (this.m_mod instanceof SocketConnectionListener) {
            ((SocketConnectionListener)this.m_mod).handleReceive(bytesReceived, data);
        }
    }

    @Override
    public void handleSocketStatus(int status) {
        this.log(4, "DeviceUtil.handleSocketStatus(" + status + ") called");
        if (this.m_mod instanceof IDeviceListener) {
            switch (status) {
                case -2: {
                    ((IDeviceListener)this.m_mod).handleOfflineEvent();
                    break;
                }
                case 1: {
                    ((IDeviceListener)this.m_mod).handleOnlineEvent();
                    break;
                }
                default: {
                    ((IDeviceListener)this.m_mod).handleErrorEvent(status);
                    break;
                }
            }
        } else if (this.m_mod instanceof SocketConnectionListener) {
            ((SocketConnectionListener)this.m_mod).handleSocketStatus(status);
        }
    }

    public void killResponseTimer() {
        if (this.tResponseTimer != null) {
            this.tResponseTimer = this.stopTimer(this.tResponseTimer, "tResponseTimer");
        }
    }

    public void startResponseTimer() {
        if (this.tResponseTimer == null) {
            this.tResponseTimer = this.startTimer("tResponseTimer", 10000L);
        }
    }

    public void startResponseTimer(long lTimeout) {
        if (this.tResponseTimer == null) {
            this.tResponseTimer = this.startTimer("tResponseTimer", lTimeout);
        }
    }

    public void setDeQueueTime(long lTime) {
        if (lTime != this.lDeQueTime[0]) {
            this.lDeQueTime[0] = lTime;
            this.restartTimeline(this.tDeQueTimeline, this.lDeQueTime);
            this.bQueueing = true;
            this.bQueueTimePaused = false;
        }
    }

    public long getDeQueueTime() {
        return this.lDeQueTime[0];
    }

    public void pauseQueueTimeline() {
        this.log(4, "DeviceUtil.pauseQueueTimeline() called");
        if (this.tDeQueTimeline != null && this.bQueueing && !this.bQueueTimePaused) {
            this.tDeQueTimeline.pause();
            this.bQueueTimePaused = true;
        }
    }

    public void restartQueueTimeline() {
        this.log(4, "DeviceUtil.restartQueueTimeline() called");
        if (this.tDeQueTimeline != null && this.bQueueing && this.bQueueTimePaused) {
            this.tDeQueTimeline.restart();
            this.bQueueTimePaused = false;
        }
    }

    public void killQueueTimeline() {
        if (this.tDeQueTimeline != null) {
            this.tDeQueTimeline.kill();
            this.bQueueing = false;
        }
    }

    public void startQueueTimeline() {
        if (this.tDeQueTimeline != null && !this.bQueueing) {
            this.tDeQueTimeline.start();
            this.log(4, "Queue started...");
            this.bQueueTimePaused = false;
            this.bQueueing = true;
        }
    }

    public void killHeartbeatTimeline() {
        if (this.tHeartBeatTimeline != null) {
            this.tHeartBeatTimeline.kill();
            this.bHeartbeating = false;
        }
    }

    public void startHeartbeatTimeline() {
        if (this.tHeartBeatTimeline != null && !this.bHeartbeating) {
            this.tHeartBeatTimeline.start();
            this.log(4, "Heartbeat started...");
            this.bHeartbeating = true;
        }
    }

    public void startPolling() {
        if (this.bDisposing) {
            return;
        }
        if (this.tPollTimeline != null && !this.bPolling) {
            this.lPollTime[0] = NumericUtil.atol(this.getProperty(POLL_TIME));
            if (this.lPollTime[0] > 0L) {
                this.tPollTimeline.reload(this.lPollTime);
                this.tPollTimeline.start();
                this.log(4, "Polling started...");
                this.bPolling = true;
            }
        }
    }

    public void stopPolling() {
        if (this.tPollTimeline != null) {
            this.tPollTimeline.kill();
            this.bPolling = false;
        }
    }

    public void fnSendStringFeedback(String msg, AdvancedEvent advEv, int zone, Object device) {
        this.sendCommandFeedback(msg, advEv, zone, (NetLinxDevice)device);
    }

    public void sendCommandFeedback(String msg, AdvancedEvent advEv, int zone, NetLinxDevice device) {
        DPS dps = null;
        try {
            if (device != null) {
                dps = device.getDPS();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendCommandFeedback(msg, advEv, zone, dps);
    }

    public void sendCommandFeedback(String msg, AdvancedEvent advEv, int zone, DPS dps) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return;
        }
        Event e = new Event(dps);
        e.dps = dps;
        e.type = 64;
        e.dataType = 9;
        e.dataValue = msg.getBytes();
        this.m_mod.processAdvancedEvent(new ModuleComponentEvent((Object)this.m_mod, advEv, e, zone));
    }

    public void fnSendLevelFeedback(int levelID, int levelValue, AdvancedEvent advEv, int zone, Object device) {
        this.sendLevelFeedback(levelID, levelValue, advEv, zone, (NetLinxDevice)device);
    }

    public void sendLevelFeedback(int levelID, int levelValue, AdvancedEvent advEv, int zone, NetLinxDevice device) {
        DPS dps = null;
        try {
            if (device != null) {
                dps = device.getDPS();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendLevelFeedback(levelID, levelValue, advEv, zone, dps);
    }

    public void sendLevelFeedback(int levelID, int levelValue, AdvancedEvent advEv, int zone, DPS dps) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return;
        }
        Event e = new Event(dps);
        e.dps = dps;
        e.type = 16;
        e.idx = levelID;
        e.dataType = 1;
        e.dataValue = new Level((long)levelValue);
        this.m_mod.processAdvancedEvent(new ModuleComponentEvent((Object)this.m_mod, advEv, e, zone));
    }

    public void fnSendChannelFeedback(int chanID, boolean chanValue, AdvancedEvent advEv, int zone, Object device) {
        this.sendChannelFeedback(chanID, chanValue, advEv, zone, (NetLinxDevice)device);
    }

    public void sendChannelFeedback(int chanID, boolean state, AdvancedEvent advEv, int zone, NetLinxDevice device) {
        DPS dps = null;
        try {
            if (device != null) {
                dps = device.getDPS();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sendChannelFeedback(chanID, state, advEv, zone, dps);
    }

    public void sendChannelFeedback(int chanID, boolean state, AdvancedEvent advEv, int zone, DPS dps) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return;
        }
        Event e = new Event(dps);
        e.dps = dps;
        e.type = state ? 4 : 8;
        e.idx = chanID;
        this.m_mod.processAdvancedEvent(new ModuleComponentEvent((Object)this.m_mod, advEv, e, zone));
    }

    public String fnGetBaudRate(String sDefaultRate, String[] sValidRates) {
        String newrate;
        if (this.m_mod == null) {
            this.error("Common device not found");
            return null;
        }
        String rate = this.getProperty(BAUD_RATE);
        if (!rate.equals(newrate = ValidateUtil.validateBaudRate(rate, sValidRates, sDefaultRate))) {
            this.log(4, "Changing Baud rate to " + newrate);
            this.setProperty(BAUD_RATE, newrate);
        }
        return newrate;
    }

    public byte fnGetDeviceID(String sDefaultID, int nMinID, int nMaxID) {
        String newID;
        if (this.m_mod == null) {
            this.error("Common device not found");
            return 0;
        }
        String id = this.getProperty(DEVICE_ID);
        if (!id.equals(newID = ValidateUtil.validateDeviceID(id, nMinID, nMaxID, sDefaultID))) {
            this.log(4, "Invalid value for the Device ID Property. Setting default.");
            this.setProperty(DEVICE_ID, newID);
        }
        return (byte)NumericUtil.ATOI(newID);
    }

    public boolean setOnlineState(boolean state) {
        if (this.blockFalseState) {
            state = true;
        }
        if (this.m_mod == null) {
            this.error("Common device not found");
            return false;
        }
        if (this.m_mod.isDeviceOnLine() != state) {
            if (this.m_bSystemDiag && !state) {
                return true;
            }
            this.m_bOnline = state;
            this.m_mod.processDeviceOnLineEvent(new ModuleComponentEvent((Object)this.m_mod, state, 1));
        }
        return state;
    }

    public boolean setDataInitializedState(boolean state) {
        if (this.blockFalseState) {
            state = true;
        }
        if (this.m_mod == null) {
            this.error("Common device not found");
            return false;
        }
        if (this.m_mod.isDataInitialized() != state) {
            if (this.m_bSystemDiag && !state) {
                return true;
            }
            this.m_bInitialized = state;
            this.m_mod.processDataInitializedEvent(new ModuleComponentEvent((Object)this.m_mod, state, 1));
            this.m_mod.processDataInitializedEvent(new ModuleComponentEvent((Object)this.m_mod, state, 1));
        }
        return state;
    }

    public String getIPAddress(String defaultIP) {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return null;
        }
        String addr = this.getProperty(IP_ADDRESS);
        if (addr != null && addr.length() > 0) {
            return addr;
        }
        addr = this.getProperty("IP-Address");
        if (addr != null && addr.length() > 0) {
            return addr;
        }
        this.log(4, "Invalid value for the IP Address Property. Setting default.");
        this.setProperty(IP_ADDRESS, defaultIP);
        return defaultIP;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int isIPControlled() throws IllegalArgumentException, NullPointerException {
        int nIPType = 0;
        if (this.m_mod == null) throw new NullPointerException("Module properties unavailable!");
        String deviceType = this.getProperty("Device-Category");
        if (deviceType == null) throw new NullPointerException("Device-Category not defined!");
        if (deviceType.length() <= 0) throw new IllegalArgumentException("Device-Category not defined!");
        if ((deviceType = deviceType.toUpperCase()).equals("IP")) {
            return 1;
        }
        if (deviceType.indexOf("IP") > -1 && (deviceType.indexOf("SERIAL") > -1 || deviceType.indexOf("RS-") > -1)) {
            String ipAddress = this.getProperty(IP_ADDRESS);
            if (ipAddress == null || ipAddress.length() == 0) {
                ipAddress = this.getProperty("IP-Address");
            }
            if (!ValidateUtil.isValidIP(ipAddress)) return 2;
            return 1;
        }
        if (deviceType.indexOf("SERIAL") > -1) return 3;
        if (deviceType.indexOf("RS-") > -1) {
            return 3;
        }
        if (deviceType.indexOf("IP") < 0) return nIPType;
        String ipAddress = this.getProperty(IP_ADDRESS);
        if (ipAddress == null || ipAddress.length() == 0) {
            ipAddress = this.getProperty("IP-Address");
        }
        if (!ValidateUtil.isValidIP(ipAddress)) return nIPType;
        return 1;
    }

    public boolean isSerialControlled(NetLinxDevice nd) throws NullPointerException {
        boolean bSerial = false;
        if (nd != null) {
            if (nd instanceof SerialDevice) {
                bSerial = true;
            }
            if (!bSerial) {
                bSerial = ValidateUtil.isValidDPS(nd.getDPS());
            }
        } else {
            throw new NullPointerException("Invalid NetLinx Device passed in!");
        }
        return bSerial;
    }

    public boolean isDynamicDevice() {
        boolean bDynamic = false;
        if (this.m_mod != null) {
            String dynamicType = this.getProperty("Dynamic-Type");
            if (dynamicType != null && dynamicType.length() > 0) {
                bDynamic = true;
            }
        } else {
            throw new NullPointerException("Module properties unavailable!");
        }
        return bDynamic;
    }

    public DPS getVirtualDPS() {
        if (this.m_mod == null) {
            this.error("Common device not found");
            return null;
        }
        String vdStr = this.getProperty("Duet-Device");
        if (vdStr == null || vdStr.length() == 0) {
            this.error("Virtual device not found");
            return null;
        }
        DPS virtualDPS = new DPS(vdStr);
        return virtualDPS;
    }

    public int getAdvancedIndex(DPS eventDPS) {
        int index = 0;
        DPS virtualDPS = this.getVirtualDPS();
        if (eventDPS.getDevice() == virtualDPS.getDevice() || eventDPS.getSystem() == virtualDPS.getSystem()) {
            index = eventDPS.getPort();
        }
        return index;
    }

    public boolean IsFileNameValid(String strFileName) {
        String strReservedName = "";
        String strmsg = "";
        if (strFileName.indexOf("?") != -1 || strFileName.indexOf("\"") != -1 || strFileName.indexOf(">") != -1 || strFileName.indexOf("<") != -1 || strFileName.indexOf("|") != -1 || strFileName.indexOf("/") != -1 || strFileName.indexOf("*") != -1) {
            strmsg = "The " + strFileName + " has invalid characters.";
            System.out.println(strmsg);
            return false;
        }
        File splitFile = new File(strFileName);
        String strName = splitFile.getName();
        String strMsgFormat = "%s is a reserved device name and cannot be used for a files.";
        int i = 0;
        while (i < 10) {
            strReservedName = "COM" + (i + 1);
            if (strName.compareToIgnoreCase(strReservedName) == 0) {
                Object[] msgList = new Object[3];
                msgList[0] = strReservedName;
                strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
                System.out.println(strmsg);
                return false;
            }
            strReservedName = "LPT" + (i + 1);
            if (strName.compareToIgnoreCase(strReservedName) == 0) {
                Object[] msgList = new Object[3];
                msgList[0] = strReservedName;
                strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
                System.out.println(strmsg);
                return false;
            }
            ++i;
        }
        if (strName.compareToIgnoreCase("NUL") == 0) {
            Object[] msgList = new Object[3];
            msgList[0] = new String("NUL");
            strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
            System.out.println(strmsg);
            return false;
        }
        if (strName.compareToIgnoreCase("PRN") == 0) {
            Object[] msgList = new Object[3];
            msgList[0] = new String("PRN");
            strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
            System.out.println(strmsg);
            return false;
        }
        if (strName.compareToIgnoreCase("AUX") == 0) {
            Object[] msgList = new Object[3];
            msgList[0] = new String("AUX");
            strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
            System.out.println(strmsg);
            return false;
        }
        if (strName.compareToIgnoreCase("CON") == 0) {
            Object[] msgList = new Object[3];
            msgList[0] = new String("CON");
            strmsg = FormatUtil.sprintf((String)strMsgFormat, (Object[])msgList);
            System.out.println(strmsg);
            return false;
        }
        return true;
    }

    public Timer startTimer(String name, long lTime) {
        if (this.bDisposing) {
            return null;
        }
        this.log(4, "startTimer(" + name + ", " + lTime + ")");
        Timer timer = new Timer((TimerListener)this, lTime);
        timer.start();
        return timer;
    }

    public void restartTimeline(Timeline timeline, long[] alTimes) {
        if (timeline != null) {
            timeline.reload(alTimes);
            timeline.start();
        }
    }

    public Timer stopTimer(Timer timer, String name) {
        if (timer != null) {
            this.log(4, "stopTimer(" + name + ")");
            timer.cancel();
            timer = null;
        }
        return timer;
    }

    protected void log(int logLevel, String message) {
        if (this.m_mod != null) {
            this.m_mod.log(logLevel, message);
        }
    }

    public void setCTSEnable(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("CTSPSH");
        }
    }

    public void setBaud(String baud) {
        this.m_dvDevice.sendCommand("SET BAUD " + baud);
    }

    public void setBaud(String baud, boolean temporary) {
        if (NetLinxSystemUtil.getDeviceID((DPS)this.m_dvDevice.getDPS()) > 255 && temporary) {
            this.m_dvDevice.sendCommand("TSET BAUD " + baud);
        } else {
            this.m_dvDevice.sendCommand("SET BAUD " + baud);
        }
    }

    public void setCharDelay(int time) {
        if ((time = (time + 99) / 100) < 256) {
            this.m_dvDevice.sendCommand("CHARD-" + time);
        } else {
            if ((time /= 10) > 255) {
                time = 255;
            }
            this.m_dvDevice.sendCommand("CHARDM-" + time);
        }
    }

    public void set9BitMode(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("B9MON");
        } else {
            this.m_dvDevice.sendCommand("B9MOFF");
        }
    }

    public void setReceiveEnable(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("RXON");
        } else {
            this.m_dvDevice.sendCommand("RXOFF");
        }
    }

    public void setHardwareHandshake(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("HSON");
        } else {
            this.m_dvDevice.sendCommand("HSOFF");
        }
    }

    public void setSoftwareHandshake(boolean on) {
        if (on) {
            this.m_dvDevice.sendCommand("XON");
        } else {
            this.m_dvDevice.sendCommand("XOFF");
        }
    }

    public void sendString(String msg) {
        this.sendString(msg.getBytes());
    }

    public void sendString(byte[] msg) {
        if (this.isIPControlEnabled()) {
            try {
                this.ipConnection.write(msg);
            }
            catch (Exception e) {
                this.log(4, "sendString: write failed " + new String(msg));
            }
        } else {
            this.m_dvDevice.sendString(msg);
        }
    }

    private void error(String str) {
        Logger.error("DeviceUtil", str);
    }

    public static String getDeviceIpAddress() {
        return deviceIpAddress;
    }

    public static String getDeviceMacAddress() {
        return deviceMacAddress;
    }

    public class Property {
        public String key = "";
        public String value = "";
    }
}

