/*
 * Decompiled with CFR 0.152.
 */
package net.controlconcepts.duet.helpers.newline.proseries.dr1_0_0;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import net.controlconcepts.duet.tools.text.newline.proseries.dr1_0_0.StringUtil;

public class WakeOnLanUtil {
    public static void sendMagicPacket(String macAddress, int port) {
        try {
            if (!macAddress.matches("([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})")) {
                throw new IllegalArgumentException("Invalid MAC address format");
            }
            byte[] macBytes = new byte[6];
            String[] hex = macAddress.split("[:-]");
            int i = 0;
            while (i < 6) {
                macBytes[i] = (byte)Integer.parseInt(hex[i], 16);
                ++i;
            }
            byte[] magicPacket = new byte[102];
            int i2 = 0;
            while (i2 < 6) {
                magicPacket[i2] = -1;
                ++i2;
            }
            i2 = 6;
            while (i2 < magicPacket.length) {
                System.arraycopy(macBytes, 0, magicPacket, i2, macBytes.length);
                i2 += macBytes.length;
            }
            System.out.println("WAKE ON LAN TRACE magicPacket | " + StringUtil.toAsciiHexString(magicPacket));
            InetAddress address = InetAddress.getByName("255.255.255.255");
            DatagramPacket packet = new DatagramPacket(magicPacket, magicPacket.length, address, port);
            DatagramSocket socket = new DatagramSocket();
            socket.setBroadcast(true);
            socket.connect(address, port);
            try {
                socket.send(packet);
                socket.send(packet);
                socket.send(packet);
            }
            catch (Exception e) {
                System.err.println("Failed to send magic packet: " + e.getMessage());
                e.printStackTrace();
            }
            socket.close();
        }
        catch (Exception ex) {
            System.out.println("WAKE ON LAN EXCEPTION | " + ex.getMessage());
        }
    }
}

